/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.admin.rest.dto.v1_0.util;

import com.liferay.object.admin.rest.dto.v1_0.ObjectStateFlow;
import com.liferay.object.admin.rest.dto.v1_0.util.ObjectStateFlowUtil;
import com.liferay.object.filter.util.ObjectFilterUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectStateFlowLocalServiceUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Objects;

public class ObjectFieldSettingUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFieldSettingUtil.class);

    public static JSONArray toJSONObject(ObjectField objectField) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        ListUtil.isNotEmptyForEach((List)objectField.getObjectFieldSettings(), objectFieldSetting -> jsonArray.put(JSONUtil.put((String)"name", (Object)objectFieldSetting.getName()).put("objectFieldId", objectFieldSetting.getObjectFieldId()).put("value", ObjectFieldSettingUtil._getValue(objectField.getBusinessType(), objectFieldSetting))));
        return jsonArray;
    }

    private static Object _getValue(String businessType, ObjectFieldSetting objectFieldSetting) {
        if (Objects.equals("Aggregation", businessType) && Objects.equals(objectFieldSetting.getName(), "filters")) {
            return ObjectFilterUtil.getObjectFiltersJSONArray((List)objectFieldSetting.getObjectFilters());
        }
        if (Objects.equals("Attachment", businessType)) {
            if (Objects.equals(objectFieldSetting.getName(), "maximumFileSize")) {
                return GetterUtil.getInteger((String)objectFieldSetting.getValue());
            }
            if (Objects.equals(objectFieldSetting.getName(), "showFilesInDocumentsAndMedia")) {
                return GetterUtil.getBoolean((String)objectFieldSetting.getValue());
            }
        } else if (Objects.equals("LongText", businessType) || Objects.equals("Text", businessType)) {
            if (Objects.equals(objectFieldSetting.getName(), "maxLength")) {
                return GetterUtil.getInteger((String)objectFieldSetting.getValue());
            }
            if (Objects.equals(objectFieldSetting.getName(), "showCounter")) {
                return GetterUtil.getBoolean((String)objectFieldSetting.getValue());
            }
        } else if (Objects.equals("Picklist", businessType) && Objects.equals(objectFieldSetting.getName(), "stateFlow")) {
            ObjectStateFlow objectStateFlow = ObjectStateFlowUtil.toObjectStateFlow(ObjectStateFlowLocalServiceUtil.fetchObjectStateFlow((long)GetterUtil.getLong((String)objectFieldSetting.getValue())));
            try {
                return JSONFactoryUtil.createJSONObject((String)objectStateFlow.toString());
            }
            catch (JSONException jsonException) {
                _log.error((Throwable)jsonException);
                return null;
            }
        }
        return objectFieldSetting.getValue();
    }
}

