/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.system;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.model.listener.SystemObjectDefinitionMetadataModelListener;
import com.liferay.object.util.LocalizedMapUtil;
import com.liferay.object.util.ObjectFieldUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseSystemObjectDefinitionMetadata
implements SystemObjectDefinitionMetadata {
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected ObjectActionEngine objectActionEngine;
    @Reference
    protected ObjectDefinitionLocalService objectDefinitionLocalService;
    @Reference
    protected ObjectEntryLocalService objectEntryLocalService;
    private ServiceRegistration<?> _serviceRegistration;

    @Override
    public String getModelClassName() {
        Class<?> modelClass = this.getModelClass();
        return modelClass.getName();
    }

    @Override
    public String getName() {
        Table table = this.getTable();
        String tableName = table.getName();
        if (tableName.endsWith("_")) {
            return tableName.substring(0, tableName.length() - 1);
        }
        return tableName;
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this._serviceRegistration = bundleContext.registerService(ModelListener.class.getName(), (Object)new SystemObjectDefinitionMetadataModelListener(this.jsonFactory, this.getModelClass(), this.objectActionEngine, this.objectDefinitionLocalService, this.objectEntryLocalService), null);
    }

    protected Map<Locale, String> createLabelMap(String labelKey) {
        return LocalizedMapUtil.getLocalizedMap(this._translate(labelKey));
    }

    protected ObjectField createObjectField(String labelKey, String name, boolean required, String type) {
        return this.createObjectField(null, labelKey, name, required, type);
    }

    protected ObjectField createObjectField(String dbColumnName, String labelKey, String name, boolean required, String type) {
        return ObjectFieldUtil.createObjectField(0L, dbColumnName, false, false, null, this._translate(labelKey), name, required, type);
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this._serviceRegistration.unregister();
    }

    private String _translate(String labelKey) {
        return LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)labelKey);
    }
}

