/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ObjectFieldSetting service. Represents a row in the &quot;ObjectFieldSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.object.model.impl.ObjectFieldSettingModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.object.model.impl.ObjectFieldSettingImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFieldSetting
 * @generated
 */
@ProviderType
public interface ObjectFieldSettingModel
	extends BaseModel<ObjectFieldSetting>, MVCCModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a object field setting model instance should use the {@link ObjectFieldSetting} interface instead.
	 */

	/**
	 * Returns the primary key of this object field setting.
	 *
	 * @return the primary key of this object field setting
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this object field setting.
	 *
	 * @param primaryKey the primary key of this object field setting
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this object field setting.
	 *
	 * @return the mvcc version of this object field setting
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this object field setting.
	 *
	 * @param mvccVersion the mvcc version of this object field setting
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this object field setting.
	 *
	 * @return the uuid of this object field setting
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this object field setting.
	 *
	 * @param uuid the uuid of this object field setting
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the object field setting ID of this object field setting.
	 *
	 * @return the object field setting ID of this object field setting
	 */
	public long getObjectFieldSettingId();

	/**
	 * Sets the object field setting ID of this object field setting.
	 *
	 * @param objectFieldSettingId the object field setting ID of this object field setting
	 */
	public void setObjectFieldSettingId(long objectFieldSettingId);

	/**
	 * Returns the company ID of this object field setting.
	 *
	 * @return the company ID of this object field setting
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this object field setting.
	 *
	 * @param companyId the company ID of this object field setting
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this object field setting.
	 *
	 * @return the user ID of this object field setting
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this object field setting.
	 *
	 * @param userId the user ID of this object field setting
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this object field setting.
	 *
	 * @return the user uuid of this object field setting
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this object field setting.
	 *
	 * @param userUuid the user uuid of this object field setting
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this object field setting.
	 *
	 * @return the user name of this object field setting
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this object field setting.
	 *
	 * @param userName the user name of this object field setting
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this object field setting.
	 *
	 * @return the create date of this object field setting
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this object field setting.
	 *
	 * @param createDate the create date of this object field setting
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this object field setting.
	 *
	 * @return the modified date of this object field setting
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this object field setting.
	 *
	 * @param modifiedDate the modified date of this object field setting
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the object field ID of this object field setting.
	 *
	 * @return the object field ID of this object field setting
	 */
	public long getObjectFieldId();

	/**
	 * Sets the object field ID of this object field setting.
	 *
	 * @param objectFieldId the object field ID of this object field setting
	 */
	public void setObjectFieldId(long objectFieldId);

	/**
	 * Returns the name of this object field setting.
	 *
	 * @return the name of this object field setting
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this object field setting.
	 *
	 * @param name the name of this object field setting
	 */
	public void setName(String name);

	/**
	 * Returns the value of this object field setting.
	 *
	 * @return the value of this object field setting
	 */
	@AutoEscape
	public String getValue();

	/**
	 * Sets the value of this object field setting.
	 *
	 * @param value the value of this object field setting
	 */
	public void setValue(String value);

	@Override
	public ObjectFieldSetting cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}