/**
 * SPDX-FileCopyrightText: (c) 2023 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ExternalReferenceCodeModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ObjectFolder service. Represents a row in the &quot;ObjectFolder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.object.model.impl.ObjectFolderModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.object.model.impl.ObjectFolderImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFolder
 * @generated
 */
@ProviderType
public interface ObjectFolderModel
	extends BaseModel<ObjectFolder>, ExternalReferenceCodeModel, LocalizedModel,
			MVCCModel, ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a object folder model instance should use the {@link ObjectFolder} interface instead.
	 */

	/**
	 * Returns the primary key of this object folder.
	 *
	 * @return the primary key of this object folder
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this object folder.
	 *
	 * @param primaryKey the primary key of this object folder
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this object folder.
	 *
	 * @return the mvcc version of this object folder
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this object folder.
	 *
	 * @param mvccVersion the mvcc version of this object folder
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this object folder.
	 *
	 * @return the uuid of this object folder
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this object folder.
	 *
	 * @param uuid the uuid of this object folder
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this object folder.
	 *
	 * @return the external reference code of this object folder
	 */
	@AutoEscape
	@Override
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this object folder.
	 *
	 * @param externalReferenceCode the external reference code of this object folder
	 */
	@Override
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the object folder ID of this object folder.
	 *
	 * @return the object folder ID of this object folder
	 */
	public long getObjectFolderId();

	/**
	 * Sets the object folder ID of this object folder.
	 *
	 * @param objectFolderId the object folder ID of this object folder
	 */
	public void setObjectFolderId(long objectFolderId);

	/**
	 * Returns the company ID of this object folder.
	 *
	 * @return the company ID of this object folder
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this object folder.
	 *
	 * @param companyId the company ID of this object folder
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this object folder.
	 *
	 * @return the user ID of this object folder
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this object folder.
	 *
	 * @param userId the user ID of this object folder
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this object folder.
	 *
	 * @return the user uuid of this object folder
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this object folder.
	 *
	 * @param userUuid the user uuid of this object folder
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this object folder.
	 *
	 * @return the user name of this object folder
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this object folder.
	 *
	 * @param userName the user name of this object folder
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this object folder.
	 *
	 * @return the create date of this object folder
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this object folder.
	 *
	 * @param createDate the create date of this object folder
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this object folder.
	 *
	 * @return the modified date of this object folder
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this object folder.
	 *
	 * @param modifiedDate the modified date of this object folder
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the label of this object folder.
	 *
	 * @return the label of this object folder
	 */
	public String getLabel();

	/**
	 * Returns the localized label of this object folder in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized label of this object folder
	 */
	@AutoEscape
	public String getLabel(Locale locale);

	/**
	 * Returns the localized label of this object folder in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized label of this object folder. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getLabel(Locale locale, boolean useDefault);

	/**
	 * Returns the localized label of this object folder in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized label of this object folder
	 */
	@AutoEscape
	public String getLabel(String languageId);

	/**
	 * Returns the localized label of this object folder in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized label of this object folder
	 */
	@AutoEscape
	public String getLabel(String languageId, boolean useDefault);

	@AutoEscape
	public String getLabelCurrentLanguageId();

	@AutoEscape
	public String getLabelCurrentValue();

	/**
	 * Returns a map of the locales and localized labels of this object folder.
	 *
	 * @return the locales and localized labels of this object folder
	 */
	public Map<Locale, String> getLabelMap();

	/**
	 * Sets the label of this object folder.
	 *
	 * @param label the label of this object folder
	 */
	public void setLabel(String label);

	/**
	 * Sets the localized label of this object folder in the language.
	 *
	 * @param label the localized label of this object folder
	 * @param locale the locale of the language
	 */
	public void setLabel(String label, Locale locale);

	/**
	 * Sets the localized label of this object folder in the language, and sets the default locale.
	 *
	 * @param label the localized label of this object folder
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setLabel(String label, Locale locale, Locale defaultLocale);

	public void setLabelCurrentLanguageId(String languageId);

	/**
	 * Sets the localized labels of this object folder from the map of locales and localized labels.
	 *
	 * @param labelMap the locales and localized labels of this object folder
	 */
	public void setLabelMap(Map<Locale, String> labelMap);

	/**
	 * Sets the localized labels of this object folder from the map of locales and localized labels, and sets the default locale.
	 *
	 * @param labelMap the locales and localized labels of this object folder
	 * @param defaultLocale the default locale
	 */
	public void setLabelMap(Map<Locale, String> labelMap, Locale defaultLocale);

	/**
	 * Returns the name of this object folder.
	 *
	 * @return the name of this object folder
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this object folder.
	 *
	 * @param name the name of this object folder
	 */
	public void setName(String name);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public ObjectFolder cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}