/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ExternalReferenceCodeModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ObjectDefinition service. Represents a row in the &quot;ObjectDefinition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.object.model.impl.ObjectDefinitionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.object.model.impl.ObjectDefinitionImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectDefinition
 * @generated
 */
@ProviderType
public interface ObjectDefinitionModel
	extends BaseModel<ObjectDefinition>, ExternalReferenceCodeModel,
			LocalizedModel, MVCCModel, ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a object definition model instance should use the {@link ObjectDefinition} interface instead.
	 */

	/**
	 * Returns the primary key of this object definition.
	 *
	 * @return the primary key of this object definition
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this object definition.
	 *
	 * @param primaryKey the primary key of this object definition
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this object definition.
	 *
	 * @return the mvcc version of this object definition
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this object definition.
	 *
	 * @param mvccVersion the mvcc version of this object definition
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this object definition.
	 *
	 * @return the uuid of this object definition
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this object definition.
	 *
	 * @param uuid the uuid of this object definition
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this object definition.
	 *
	 * @return the external reference code of this object definition
	 */
	@AutoEscape
	@Override
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this object definition.
	 *
	 * @param externalReferenceCode the external reference code of this object definition
	 */
	@Override
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the object definition ID of this object definition.
	 *
	 * @return the object definition ID of this object definition
	 */
	public long getObjectDefinitionId();

	/**
	 * Sets the object definition ID of this object definition.
	 *
	 * @param objectDefinitionId the object definition ID of this object definition
	 */
	public void setObjectDefinitionId(long objectDefinitionId);

	/**
	 * Returns the company ID of this object definition.
	 *
	 * @return the company ID of this object definition
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this object definition.
	 *
	 * @param companyId the company ID of this object definition
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this object definition.
	 *
	 * @return the user ID of this object definition
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this object definition.
	 *
	 * @param userId the user ID of this object definition
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this object definition.
	 *
	 * @return the user uuid of this object definition
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this object definition.
	 *
	 * @param userUuid the user uuid of this object definition
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this object definition.
	 *
	 * @return the user name of this object definition
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this object definition.
	 *
	 * @param userName the user name of this object definition
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this object definition.
	 *
	 * @return the create date of this object definition
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this object definition.
	 *
	 * @param createDate the create date of this object definition
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this object definition.
	 *
	 * @return the modified date of this object definition
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this object definition.
	 *
	 * @param modifiedDate the modified date of this object definition
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the account entry restricted object field ID of this object definition.
	 *
	 * @return the account entry restricted object field ID of this object definition
	 */
	public long getAccountEntryRestrictedObjectFieldId();

	/**
	 * Sets the account entry restricted object field ID of this object definition.
	 *
	 * @param accountEntryRestrictedObjectFieldId the account entry restricted object field ID of this object definition
	 */
	public void setAccountEntryRestrictedObjectFieldId(
		long accountEntryRestrictedObjectFieldId);

	/**
	 * Returns the description object field ID of this object definition.
	 *
	 * @return the description object field ID of this object definition
	 */
	public long getDescriptionObjectFieldId();

	/**
	 * Sets the description object field ID of this object definition.
	 *
	 * @param descriptionObjectFieldId the description object field ID of this object definition
	 */
	public void setDescriptionObjectFieldId(long descriptionObjectFieldId);

	/**
	 * Returns the object folder ID of this object definition.
	 *
	 * @return the object folder ID of this object definition
	 */
	public long getObjectFolderId();

	/**
	 * Sets the object folder ID of this object definition.
	 *
	 * @param objectFolderId the object folder ID of this object definition
	 */
	public void setObjectFolderId(long objectFolderId);

	/**
	 * Returns the root object definition ID of this object definition.
	 *
	 * @return the root object definition ID of this object definition
	 */
	public long getRootObjectDefinitionId();

	/**
	 * Sets the root object definition ID of this object definition.
	 *
	 * @param rootObjectDefinitionId the root object definition ID of this object definition
	 */
	public void setRootObjectDefinitionId(long rootObjectDefinitionId);

	/**
	 * Returns the title object field ID of this object definition.
	 *
	 * @return the title object field ID of this object definition
	 */
	public long getTitleObjectFieldId();

	/**
	 * Sets the title object field ID of this object definition.
	 *
	 * @param titleObjectFieldId the title object field ID of this object definition
	 */
	public void setTitleObjectFieldId(long titleObjectFieldId);

	/**
	 * Returns the account entry restricted of this object definition.
	 *
	 * @return the account entry restricted of this object definition
	 */
	public boolean getAccountEntryRestricted();

	/**
	 * Returns <code>true</code> if this object definition is account entry restricted.
	 *
	 * @return <code>true</code> if this object definition is account entry restricted; <code>false</code> otherwise
	 */
	public boolean isAccountEntryRestricted();

	/**
	 * Sets whether this object definition is account entry restricted.
	 *
	 * @param accountEntryRestricted the account entry restricted of this object definition
	 */
	public void setAccountEntryRestricted(boolean accountEntryRestricted);

	/**
	 * Returns the active of this object definition.
	 *
	 * @return the active of this object definition
	 */
	public boolean getActive();

	/**
	 * Returns <code>true</code> if this object definition is active.
	 *
	 * @return <code>true</code> if this object definition is active; <code>false</code> otherwise
	 */
	public boolean isActive();

	/**
	 * Sets whether this object definition is active.
	 *
	 * @param active the active of this object definition
	 */
	public void setActive(boolean active);

	/**
	 * Returns the db table name of this object definition.
	 *
	 * @return the db table name of this object definition
	 */
	@AutoEscape
	public String getDBTableName();

	/**
	 * Sets the db table name of this object definition.
	 *
	 * @param dbTableName the db table name of this object definition
	 */
	public void setDBTableName(String dbTableName);

	/**
	 * Returns the label of this object definition.
	 *
	 * @return the label of this object definition
	 */
	public String getLabel();

	/**
	 * Returns the localized label of this object definition in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized label of this object definition
	 */
	@AutoEscape
	public String getLabel(Locale locale);

	/**
	 * Returns the localized label of this object definition in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized label of this object definition. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getLabel(Locale locale, boolean useDefault);

	/**
	 * Returns the localized label of this object definition in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized label of this object definition
	 */
	@AutoEscape
	public String getLabel(String languageId);

	/**
	 * Returns the localized label of this object definition in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized label of this object definition
	 */
	@AutoEscape
	public String getLabel(String languageId, boolean useDefault);

	@AutoEscape
	public String getLabelCurrentLanguageId();

	@AutoEscape
	public String getLabelCurrentValue();

	/**
	 * Returns a map of the locales and localized labels of this object definition.
	 *
	 * @return the locales and localized labels of this object definition
	 */
	public Map<Locale, String> getLabelMap();

	/**
	 * Sets the label of this object definition.
	 *
	 * @param label the label of this object definition
	 */
	public void setLabel(String label);

	/**
	 * Sets the localized label of this object definition in the language.
	 *
	 * @param label the localized label of this object definition
	 * @param locale the locale of the language
	 */
	public void setLabel(String label, Locale locale);

	/**
	 * Sets the localized label of this object definition in the language, and sets the default locale.
	 *
	 * @param label the localized label of this object definition
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setLabel(String label, Locale locale, Locale defaultLocale);

	public void setLabelCurrentLanguageId(String languageId);

	/**
	 * Sets the localized labels of this object definition from the map of locales and localized labels.
	 *
	 * @param labelMap the locales and localized labels of this object definition
	 */
	public void setLabelMap(Map<Locale, String> labelMap);

	/**
	 * Sets the localized labels of this object definition from the map of locales and localized labels, and sets the default locale.
	 *
	 * @param labelMap the locales and localized labels of this object definition
	 * @param defaultLocale the default locale
	 */
	public void setLabelMap(Map<Locale, String> labelMap, Locale defaultLocale);

	/**
	 * Returns the class name of this object definition.
	 *
	 * @return the class name of this object definition
	 */
	@AutoEscape
	public String getClassName();

	/**
	 * Sets the class name of this object definition.
	 *
	 * @param className the class name of this object definition
	 */
	public void setClassName(String className);

	/**
	 * Returns the enable categorization of this object definition.
	 *
	 * @return the enable categorization of this object definition
	 */
	public boolean getEnableCategorization();

	/**
	 * Returns <code>true</code> if this object definition is enable categorization.
	 *
	 * @return <code>true</code> if this object definition is enable categorization; <code>false</code> otherwise
	 */
	public boolean isEnableCategorization();

	/**
	 * Sets whether this object definition is enable categorization.
	 *
	 * @param enableCategorization the enable categorization of this object definition
	 */
	public void setEnableCategorization(boolean enableCategorization);

	/**
	 * Returns the enable comments of this object definition.
	 *
	 * @return the enable comments of this object definition
	 */
	public boolean getEnableComments();

	/**
	 * Returns <code>true</code> if this object definition is enable comments.
	 *
	 * @return <code>true</code> if this object definition is enable comments; <code>false</code> otherwise
	 */
	public boolean isEnableComments();

	/**
	 * Sets whether this object definition is enable comments.
	 *
	 * @param enableComments the enable comments of this object definition
	 */
	public void setEnableComments(boolean enableComments);

	/**
	 * Returns the enable index search of this object definition.
	 *
	 * @return the enable index search of this object definition
	 */
	public boolean getEnableIndexSearch();

	/**
	 * Returns <code>true</code> if this object definition is enable index search.
	 *
	 * @return <code>true</code> if this object definition is enable index search; <code>false</code> otherwise
	 */
	public boolean isEnableIndexSearch();

	/**
	 * Sets whether this object definition is enable index search.
	 *
	 * @param enableIndexSearch the enable index search of this object definition
	 */
	public void setEnableIndexSearch(boolean enableIndexSearch);

	/**
	 * Returns the enable localization of this object definition.
	 *
	 * @return the enable localization of this object definition
	 */
	public boolean getEnableLocalization();

	/**
	 * Returns <code>true</code> if this object definition is enable localization.
	 *
	 * @return <code>true</code> if this object definition is enable localization; <code>false</code> otherwise
	 */
	public boolean isEnableLocalization();

	/**
	 * Sets whether this object definition is enable localization.
	 *
	 * @param enableLocalization the enable localization of this object definition
	 */
	public void setEnableLocalization(boolean enableLocalization);

	/**
	 * Returns the enable object entry draft of this object definition.
	 *
	 * @return the enable object entry draft of this object definition
	 */
	public boolean getEnableObjectEntryDraft();

	/**
	 * Returns <code>true</code> if this object definition is enable object entry draft.
	 *
	 * @return <code>true</code> if this object definition is enable object entry draft; <code>false</code> otherwise
	 */
	public boolean isEnableObjectEntryDraft();

	/**
	 * Sets whether this object definition is enable object entry draft.
	 *
	 * @param enableObjectEntryDraft the enable object entry draft of this object definition
	 */
	public void setEnableObjectEntryDraft(boolean enableObjectEntryDraft);

	/**
	 * Returns the enable object entry history of this object definition.
	 *
	 * @return the enable object entry history of this object definition
	 */
	public boolean getEnableObjectEntryHistory();

	/**
	 * Returns <code>true</code> if this object definition is enable object entry history.
	 *
	 * @return <code>true</code> if this object definition is enable object entry history; <code>false</code> otherwise
	 */
	public boolean isEnableObjectEntryHistory();

	/**
	 * Sets whether this object definition is enable object entry history.
	 *
	 * @param enableObjectEntryHistory the enable object entry history of this object definition
	 */
	public void setEnableObjectEntryHistory(boolean enableObjectEntryHistory);

	/**
	 * Returns the modifiable of this object definition.
	 *
	 * @return the modifiable of this object definition
	 */
	public boolean getModifiable();

	/**
	 * Returns <code>true</code> if this object definition is modifiable.
	 *
	 * @return <code>true</code> if this object definition is modifiable; <code>false</code> otherwise
	 */
	public boolean isModifiable();

	/**
	 * Sets whether this object definition is modifiable.
	 *
	 * @param modifiable the modifiable of this object definition
	 */
	public void setModifiable(boolean modifiable);

	/**
	 * Returns the name of this object definition.
	 *
	 * @return the name of this object definition
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this object definition.
	 *
	 * @param name the name of this object definition
	 */
	public void setName(String name);

	/**
	 * Returns the panel app order of this object definition.
	 *
	 * @return the panel app order of this object definition
	 */
	@AutoEscape
	public String getPanelAppOrder();

	/**
	 * Sets the panel app order of this object definition.
	 *
	 * @param panelAppOrder the panel app order of this object definition
	 */
	public void setPanelAppOrder(String panelAppOrder);

	/**
	 * Returns the panel category key of this object definition.
	 *
	 * @return the panel category key of this object definition
	 */
	@AutoEscape
	public String getPanelCategoryKey();

	/**
	 * Sets the panel category key of this object definition.
	 *
	 * @param panelCategoryKey the panel category key of this object definition
	 */
	public void setPanelCategoryKey(String panelCategoryKey);

	/**
	 * Returns the pk object field db column name of this object definition.
	 *
	 * @return the pk object field db column name of this object definition
	 */
	@AutoEscape
	public String getPKObjectFieldDBColumnName();

	/**
	 * Sets the pk object field db column name of this object definition.
	 *
	 * @param pkObjectFieldDBColumnName the pk object field db column name of this object definition
	 */
	public void setPKObjectFieldDBColumnName(String pkObjectFieldDBColumnName);

	/**
	 * Returns the pk object field name of this object definition.
	 *
	 * @return the pk object field name of this object definition
	 */
	@AutoEscape
	public String getPKObjectFieldName();

	/**
	 * Sets the pk object field name of this object definition.
	 *
	 * @param pkObjectFieldName the pk object field name of this object definition
	 */
	public void setPKObjectFieldName(String pkObjectFieldName);

	/**
	 * Returns the plural label of this object definition.
	 *
	 * @return the plural label of this object definition
	 */
	public String getPluralLabel();

	/**
	 * Returns the localized plural label of this object definition in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized plural label of this object definition
	 */
	@AutoEscape
	public String getPluralLabel(Locale locale);

	/**
	 * Returns the localized plural label of this object definition in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized plural label of this object definition. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getPluralLabel(Locale locale, boolean useDefault);

	/**
	 * Returns the localized plural label of this object definition in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized plural label of this object definition
	 */
	@AutoEscape
	public String getPluralLabel(String languageId);

	/**
	 * Returns the localized plural label of this object definition in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized plural label of this object definition
	 */
	@AutoEscape
	public String getPluralLabel(String languageId, boolean useDefault);

	@AutoEscape
	public String getPluralLabelCurrentLanguageId();

	@AutoEscape
	public String getPluralLabelCurrentValue();

	/**
	 * Returns a map of the locales and localized plural labels of this object definition.
	 *
	 * @return the locales and localized plural labels of this object definition
	 */
	public Map<Locale, String> getPluralLabelMap();

	/**
	 * Sets the plural label of this object definition.
	 *
	 * @param pluralLabel the plural label of this object definition
	 */
	public void setPluralLabel(String pluralLabel);

	/**
	 * Sets the localized plural label of this object definition in the language.
	 *
	 * @param pluralLabel the localized plural label of this object definition
	 * @param locale the locale of the language
	 */
	public void setPluralLabel(String pluralLabel, Locale locale);

	/**
	 * Sets the localized plural label of this object definition in the language, and sets the default locale.
	 *
	 * @param pluralLabel the localized plural label of this object definition
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setPluralLabel(
		String pluralLabel, Locale locale, Locale defaultLocale);

	public void setPluralLabelCurrentLanguageId(String languageId);

	/**
	 * Sets the localized plural labels of this object definition from the map of locales and localized plural labels.
	 *
	 * @param pluralLabelMap the locales and localized plural labels of this object definition
	 */
	public void setPluralLabelMap(Map<Locale, String> pluralLabelMap);

	/**
	 * Sets the localized plural labels of this object definition from the map of locales and localized plural labels, and sets the default locale.
	 *
	 * @param pluralLabelMap the locales and localized plural labels of this object definition
	 * @param defaultLocale the default locale
	 */
	public void setPluralLabelMap(
		Map<Locale, String> pluralLabelMap, Locale defaultLocale);

	/**
	 * Returns the portlet of this object definition.
	 *
	 * @return the portlet of this object definition
	 */
	public boolean getPortlet();

	/**
	 * Returns <code>true</code> if this object definition is portlet.
	 *
	 * @return <code>true</code> if this object definition is portlet; <code>false</code> otherwise
	 */
	public boolean isPortlet();

	/**
	 * Sets whether this object definition is portlet.
	 *
	 * @param portlet the portlet of this object definition
	 */
	public void setPortlet(boolean portlet);

	/**
	 * Returns the scope of this object definition.
	 *
	 * @return the scope of this object definition
	 */
	@AutoEscape
	public String getScope();

	/**
	 * Sets the scope of this object definition.
	 *
	 * @param scope the scope of this object definition
	 */
	public void setScope(String scope);

	/**
	 * Returns the storage type of this object definition.
	 *
	 * @return the storage type of this object definition
	 */
	@AutoEscape
	public String getStorageType();

	/**
	 * Sets the storage type of this object definition.
	 *
	 * @param storageType the storage type of this object definition
	 */
	public void setStorageType(String storageType);

	/**
	 * Returns the system of this object definition.
	 *
	 * @return the system of this object definition
	 */
	public boolean getSystem();

	/**
	 * Returns <code>true</code> if this object definition is system.
	 *
	 * @return <code>true</code> if this object definition is system; <code>false</code> otherwise
	 */
	public boolean isSystem();

	/**
	 * Sets whether this object definition is system.
	 *
	 * @param system the system of this object definition
	 */
	public void setSystem(boolean system);

	/**
	 * Returns the version of this object definition.
	 *
	 * @return the version of this object definition
	 */
	public int getVersion();

	/**
	 * Sets the version of this object definition.
	 *
	 * @param version the version of this object definition
	 */
	public void setVersion(int version);

	/**
	 * Returns the status of this object definition.
	 *
	 * @return the status of this object definition
	 */
	public int getStatus();

	/**
	 * Sets the status of this object definition.
	 *
	 * @param status the status of this object definition
	 */
	public void setStatus(int status);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public ObjectDefinition cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}