/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ObjectLayout service. Represents a row in the &quot;ObjectLayout&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.object.model.impl.ObjectLayoutModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.object.model.impl.ObjectLayoutImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectLayout
 * @generated
 */
@ProviderType
public interface ObjectLayoutModel
	extends BaseModel<ObjectLayout>, LocalizedModel, MVCCModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a object layout model instance should use the {@link ObjectLayout} interface instead.
	 */

	/**
	 * Returns the primary key of this object layout.
	 *
	 * @return the primary key of this object layout
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this object layout.
	 *
	 * @param primaryKey the primary key of this object layout
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this object layout.
	 *
	 * @return the mvcc version of this object layout
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this object layout.
	 *
	 * @param mvccVersion the mvcc version of this object layout
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this object layout.
	 *
	 * @return the uuid of this object layout
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this object layout.
	 *
	 * @param uuid the uuid of this object layout
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the object layout ID of this object layout.
	 *
	 * @return the object layout ID of this object layout
	 */
	public long getObjectLayoutId();

	/**
	 * Sets the object layout ID of this object layout.
	 *
	 * @param objectLayoutId the object layout ID of this object layout
	 */
	public void setObjectLayoutId(long objectLayoutId);

	/**
	 * Returns the company ID of this object layout.
	 *
	 * @return the company ID of this object layout
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this object layout.
	 *
	 * @param companyId the company ID of this object layout
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this object layout.
	 *
	 * @return the user ID of this object layout
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this object layout.
	 *
	 * @param userId the user ID of this object layout
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this object layout.
	 *
	 * @return the user uuid of this object layout
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this object layout.
	 *
	 * @param userUuid the user uuid of this object layout
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this object layout.
	 *
	 * @return the user name of this object layout
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this object layout.
	 *
	 * @param userName the user name of this object layout
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this object layout.
	 *
	 * @return the create date of this object layout
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this object layout.
	 *
	 * @param createDate the create date of this object layout
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this object layout.
	 *
	 * @return the modified date of this object layout
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this object layout.
	 *
	 * @param modifiedDate the modified date of this object layout
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the object definition ID of this object layout.
	 *
	 * @return the object definition ID of this object layout
	 */
	public long getObjectDefinitionId();

	/**
	 * Sets the object definition ID of this object layout.
	 *
	 * @param objectDefinitionId the object definition ID of this object layout
	 */
	public void setObjectDefinitionId(long objectDefinitionId);

	/**
	 * Returns the default object layout of this object layout.
	 *
	 * @return the default object layout of this object layout
	 */
	public boolean getDefaultObjectLayout();

	/**
	 * Returns <code>true</code> if this object layout is default object layout.
	 *
	 * @return <code>true</code> if this object layout is default object layout; <code>false</code> otherwise
	 */
	public boolean isDefaultObjectLayout();

	/**
	 * Sets whether this object layout is default object layout.
	 *
	 * @param defaultObjectLayout the default object layout of this object layout
	 */
	public void setDefaultObjectLayout(boolean defaultObjectLayout);

	/**
	 * Returns the name of this object layout.
	 *
	 * @return the name of this object layout
	 */
	public String getName();

	/**
	 * Returns the localized name of this object layout in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized name of this object layout
	 */
	@AutoEscape
	public String getName(Locale locale);

	/**
	 * Returns the localized name of this object layout in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this object layout. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getName(Locale locale, boolean useDefault);

	/**
	 * Returns the localized name of this object layout in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized name of this object layout
	 */
	@AutoEscape
	public String getName(String languageId);

	/**
	 * Returns the localized name of this object layout in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this object layout
	 */
	@AutoEscape
	public String getName(String languageId, boolean useDefault);

	@AutoEscape
	public String getNameCurrentLanguageId();

	@AutoEscape
	public String getNameCurrentValue();

	/**
	 * Returns a map of the locales and localized names of this object layout.
	 *
	 * @return the locales and localized names of this object layout
	 */
	public Map<Locale, String> getNameMap();

	/**
	 * Sets the name of this object layout.
	 *
	 * @param name the name of this object layout
	 */
	public void setName(String name);

	/**
	 * Sets the localized name of this object layout in the language.
	 *
	 * @param name the localized name of this object layout
	 * @param locale the locale of the language
	 */
	public void setName(String name, Locale locale);

	/**
	 * Sets the localized name of this object layout in the language, and sets the default locale.
	 *
	 * @param name the localized name of this object layout
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setName(String name, Locale locale, Locale defaultLocale);

	public void setNameCurrentLanguageId(String languageId);

	/**
	 * Sets the localized names of this object layout from the map of locales and localized names.
	 *
	 * @param nameMap the locales and localized names of this object layout
	 */
	public void setNameMap(Map<Locale, String> nameMap);

	/**
	 * Sets the localized names of this object layout from the map of locales and localized names, and sets the default locale.
	 *
	 * @param nameMap the locales and localized names of this object layout
	 * @param defaultLocale the default locale
	 */
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public ObjectLayout cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}