/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.util.LocalizedMapUtil;
import com.liferay.object.util.ObjectFieldUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={})
public class ObjectDefinitionSampleGenerator {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this._addSampleObjectDefinition();
    }

    private void _addSampleObjectDefinition() throws Exception {
        List companies = this._companyLocalService.getCompanies();
        if (companies.size() != 1) {
            return;
        }
        Company company = (Company)companies.get(0);
        User user = this._userLocalService.fetchUserByEmailAddress(company.getCompanyId(), "test@liferay.com");
        if (user == null) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(company.getCompanyId(), "C_SampleObjectDefinition");
        if (objectDefinition != null) {
            return;
        }
        objectDefinition = this._objectDefinitionLocalService.addCustomObjectDefinition(user.getUserId(), LocalizedMapUtil.getLocalizedMap((String)"Sample Object Definition"), "SampleObjectDefinition", "100", "control_panel.sites", LocalizedMapUtil.getLocalizedMap((String)"Sample Object Definitions"), "company", Arrays.asList(ObjectFieldUtil.createObjectField((boolean)true, (boolean)false, null, (String)"Able", (String)"able", (boolean)false, (String)"Long"), ObjectFieldUtil.createObjectField((boolean)true, (boolean)false, null, (String)"Baker", (String)"baker", (boolean)false, (String)"Boolean"), ObjectFieldUtil.createObjectField((boolean)true, (boolean)false, null, (String)"Charlie", (String)"charlie", (boolean)false, (String)"Date"), ObjectFieldUtil.createObjectField((boolean)true, (boolean)false, null, (String)"Dog", (String)"dog", (boolean)false, (String)"String"), ObjectFieldUtil.createObjectField((long)0L, null, (boolean)true, (boolean)true, null, (String)"Easy", (String)"easy", (boolean)false, (String)"String"), ObjectFieldUtil.createObjectField((long)0L, null, (boolean)true, (boolean)false, (String)"en_US", (String)"Fox", (String)"fox", (boolean)false, (String)"String"), ObjectFieldUtil.createObjectField((long)0L, null, (boolean)false, (boolean)false, null, (String)"George", (String)"george", (boolean)false, (String)"String"), ObjectFieldUtil.createObjectField((boolean)true, (boolean)false, null, (String)"How", (String)"how", (boolean)false, (String)"Double"), ObjectFieldUtil.createObjectField((boolean)true, (boolean)false, null, (String)"Item", (String)"item", (boolean)false, (String)"Integer"), ObjectFieldUtil.createObjectField((boolean)true, (boolean)false, null, (String)"Jig", (String)"jig", (boolean)false, (String)"BigDecimal")));
        objectDefinition = this._objectDefinitionLocalService.publishCustomObjectDefinition(user.getUserId(), objectDefinition.getObjectDefinitionId());
        for (int i = 0; i < 100; ++i) {
            this._objectEntryLocalService.addObjectEntry(user.getUserId(), 0L, objectDefinition.getObjectDefinitionId(), (Map)HashMapBuilder.put((Object)"able", (Object)(10 + i)).put((Object)"baker", (Object)(i % 2 == 0 ? 1 : 0)).put((Object)"charlie", (Object)new Date()).put((Object)"dog", (Object)("The quick brown fox jumps over the lazy dog. " + i + "!")).put((Object)"easy", (Object)("test" + i)).put((Object)"fox", (Object)("The english brown fox trusted the lazy dog. " + i + "!")).put((Object)"george", (Object)("The unsearchable brown fox jumps over the lazy dog. " + i)).put((Object)"how", (Object)(180.5 + (double)i)).put((Object)"item", (Object)(5 + i)).put((Object)"jig", (Object)BigDecimal.valueOf(45L + (long)i)).build(), new ServiceContext());
        }
    }
}

