/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.executor;

import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ObjectActionExecutorRegistry.class})
public class ObjectActionExecutorRegistryImpl
implements ObjectActionExecutorRegistry {
    private ServiceTrackerMap<String, ObjectActionExecutor> _serviceTrackerMap;

    public ObjectActionExecutor getObjectActionExecutor(String objectActionExecutorKey) {
        ObjectActionExecutor objectActionExecutor = (ObjectActionExecutor)this._serviceTrackerMap.getService((Object)objectActionExecutorKey);
        if (objectActionExecutor == null) {
            throw new IllegalArgumentException("No object action executor found with key " + objectActionExecutorKey);
        }
        return objectActionExecutor;
    }

    public List<ObjectActionExecutor> getObjectActionExecutors() {
        Collection objectActionExecutorsCollection = this._serviceTrackerMap.values();
        if (objectActionExecutorsCollection == null) {
            return Collections.emptyList();
        }
        ArrayList<ObjectActionExecutor> objectActionExecutors = new ArrayList<ObjectActionExecutor>(objectActionExecutorsCollection);
        objectActionExecutors.sort((objectActionExecutor1, objectActionExecutor2) -> {
            String key1 = objectActionExecutor1.getKey();
            String key2 = objectActionExecutor2.getKey();
            return key1.compareTo(key2);
        });
        return objectActionExecutors;
    }

    public boolean hasObjectActionExecutor(String objectActionExecutorKey) {
        return this._serviceTrackerMap.containsKey((Object)objectActionExecutorKey);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ObjectActionExecutor.class, null, (serviceReference, emitter) -> {
            ObjectActionExecutor objectActionExecutor = (ObjectActionExecutor)bundleContext.getService(serviceReference);
            emitter.emit((Object)objectActionExecutor.getKey());
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

