/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.info.collection.provider;

import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.ConfigurableInfoCollectionProvider;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.SelectInfoFieldType;
import com.liferay.info.filter.InfoFilter;
import com.liferay.info.filter.KeywordsInfoFilter;
import com.liferay.info.form.InfoForm;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;

public class ObjectEntrySingleFormVariationInfoCollectionProvider
implements ConfigurableInfoCollectionProvider<ObjectEntry>,
FilteredInfoCollectionProvider<ObjectEntry>,
SingleFormVariationInfoCollectionProvider<ObjectEntry> {
    private final ListTypeEntryLocalService _listTypeEntryLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectScopeProviderRegistry _objectScopeProviderRegistry;

    public ObjectEntrySingleFormVariationInfoCollectionProvider(ListTypeEntryLocalService listTypeEntryLocalService, ObjectDefinition objectDefinition, ObjectEntryLocalService objectEntryLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectScopeProviderRegistry objectScopeProviderRegistry) {
        this._listTypeEntryLocalService = listTypeEntryLocalService;
        this._objectDefinition = objectDefinition;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectScopeProviderRegistry = objectScopeProviderRegistry;
    }

    public InfoPage<ObjectEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)this._objectDefinition.getClassName());
            Hits hits = indexer.search(this._buildSearchContext(collectionQuery));
            return InfoPage.of((List)TransformUtil.transformToList((Object[])hits.getDocs(), document -> {
                long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
                return this._objectEntryLocalService.fetchObjectEntry(classPK);
            }), (Pagination)collectionQuery.getPagination(), (int)hits.getLength());
        }
        catch (PortalException portalException) {
            throw new RuntimeException("Unable to get object entries for object definition " + this._objectDefinition.getObjectDefinitionId(), portalException);
        }
    }

    public InfoForm getConfigurationInfoForm() {
        return InfoForm.builder().infoFieldSetEntry(InfoFieldSet.builder().infoFieldSetEntry(unsafeConsumer -> {
            for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId())) {
                if (!Objects.equals(objectField.getType(), "Boolean") && (!Objects.equals(objectField.getType(), "String") || objectField.getListTypeDefinitionId() == 0L) || !objectField.isIndexed()) continue;
                unsafeConsumer.accept((Object)InfoField.builder().infoFieldType((InfoFieldType)SelectInfoFieldType.INSTANCE).name(objectField.getName()).attribute(SelectInfoFieldType.OPTIONS, this._getOptions(objectField)).labelInfoLocalizedValue(InfoLocalizedValue.builder().values(objectField.getLabelMap()).build()).localizable(true).build());
            }
        }).build()).build();
    }

    public String getFormVariationKey() {
        return String.valueOf(this._objectDefinition.getObjectDefinitionId());
    }

    public String getKey() {
        return StringBundler.concat((String[])new String[]{super.getKey(), "_", this._objectDefinition.getName()});
    }

    public String getLabel(Locale locale) {
        return this._objectDefinition.getPluralLabel(locale);
    }

    public List<InfoFilter> getSupportedInfoFilters() {
        return Arrays.asList(new KeywordsInfoFilter());
    }

    private SearchContext _buildSearchContext(CollectionQuery collectionQuery) throws PortalException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
        searchContext.setAttribute("objectDefinitionId", (Serializable)Long.valueOf(this._objectDefinition.getObjectDefinitionId()));
        searchContext.setBooleanClauses(this._getBooleanClauses(collectionQuery));
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        searchContext.setCompanyId(serviceContext.getCompanyId());
        Pagination pagination = collectionQuery.getPagination();
        searchContext.setEnd(pagination.getEnd());
        searchContext.setGroupIds(new long[]{this._getGroupId()});
        Optional keywordsInfoFilterOptional = collectionQuery.getInfoFilterOptional(KeywordsInfoFilter.class);
        if (keywordsInfoFilterOptional.isPresent()) {
            KeywordsInfoFilter keywordsInfoFilter = (KeywordsInfoFilter)keywordsInfoFilterOptional.get();
            searchContext.setKeywords(keywordsInfoFilter.getKeywords());
        }
        searchContext.setStart(pagination.getStart());
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private BooleanClause[] _getBooleanClauses(CollectionQuery collectionQuery) throws ParseException {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        List objectFields = this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId());
        Optional configurationOptional = collectionQuery.getConfigurationOptional();
        Map configuration = configurationOptional.orElse(Collections.emptyMap());
        for (Map.Entry entry : configuration.entrySet()) {
            ObjectField objectField;
            String[] values = (String[])entry.getValue();
            if (values == null || values.length == 0 || values[0].isEmpty() || (objectField = this._getObjectField((String)entry.getKey(), objectFields)) == null) continue;
            BooleanQueryImpl nestedBooleanQuery = new BooleanQueryImpl();
            nestedBooleanQuery.add((Query)new TermQueryImpl(this._getField(objectField), ((String[])entry.getValue())[0]), BooleanClauseOccur.MUST);
            nestedBooleanQuery.add((Query)new TermQueryImpl("nestedFieldArray.fieldName", (String)entry.getKey()), BooleanClauseOccur.MUST);
            booleanQuery.add((Query)new NestedQuery("nestedFieldArray", (Query)nestedBooleanQuery), BooleanClauseOccur.MUST);
        }
        return new BooleanClause[]{BooleanClauseFactoryUtil.create((Query)booleanQuery, (String)BooleanClauseOccur.MUST.getName())};
    }

    private String _getField(ObjectField objectField) {
        if (Objects.equals(objectField.getType(), "Boolean")) {
            return "nestedFieldArray.value_boolean";
        }
        if (Objects.equals(objectField.getType(), "String")) {
            return "nestedFieldArray.value_text";
        }
        return "";
    }

    private long _getGroupId() throws PortalException {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(this._objectDefinition.getScope());
        if (!objectScopeProvider.isGroupAware()) {
            return 0L;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        return objectScopeProvider.getGroupId(serviceContext.getRequest());
    }

    private ObjectField _getObjectField(String name, List<ObjectField> objectFields) {
        for (ObjectField objectField : objectFields) {
            if (!Objects.equals(name, objectField.getName())) continue;
            return objectField;
        }
        return null;
    }

    private List<SelectInfoFieldType.Option> _getOptions(ObjectField objectField) {
        ArrayList<SelectInfoFieldType.Option> options = new ArrayList<SelectInfoFieldType.Option>();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)serviceContext.getLocale(), this.getClass());
        options.add(new SelectInfoFieldType.Option(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"choose-an-option"), ""));
        if (Objects.equals(objectField.getType(), "Boolean")) {
            options.add(new SelectInfoFieldType.Option(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"true"), "true"));
            options.add(new SelectInfoFieldType.Option(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"false"), "false"));
        } else if (objectField.getListTypeDefinitionId() != 0L) {
            options.addAll(TransformUtil.transform((Collection)this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId(), -1, -1), listTypeEntry -> new SelectInfoFieldType.Option(listTypeEntry.getName(serviceContext.getLocale()), listTypeEntry.getKey())));
        }
        return options;
    }
}

