/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.deployer.ObjectDefinitionDeployer;
import com.liferay.object.exception.DuplicateObjectDefinitionException;
import com.liferay.object.exception.NoSuchObjectFieldException;
import com.liferay.object.exception.ObjectDefinitionLabelException;
import com.liferay.object.exception.ObjectDefinitionNameException;
import com.liferay.object.exception.ObjectDefinitionPluralLabelException;
import com.liferay.object.exception.ObjectDefinitionScopeException;
import com.liferay.object.exception.ObjectDefinitionStatusException;
import com.liferay.object.exception.ObjectDefinitionVersionException;
import com.liferay.object.exception.RequiredObjectDefinitionException;
import com.liferay.object.internal.deployer.ObjectDefinitionDeployerImpl;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.impl.ObjectDefinitionImpl;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.base.ObjectDefinitionLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectEntryPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchRegistrarHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(property={"model.class.name=com.liferay.object.model.ObjectDefinition"}, service={AopService.class})
public class ObjectDefinitionLocalServiceImpl
extends ObjectDefinitionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDefinitionLocalServiceImpl.class);
    private BundleContext _bundleContext;
    @Reference
    private DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ModelSearchRegistrarHelper _modelSearchRegistrarHelper;
    private ServiceTracker<ObjectDefinitionDeployer, ObjectDefinitionDeployer> _objectDefinitionDeployerServiceTracker;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryPersistence _objectEntryPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private ResourceLocalService _resourceLocalService;
    private final Map<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> _serviceRegistrationsMaps = Collections.synchronizedMap(new LinkedHashMap());
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;
    @Reference(target="(model.pre.filter.contributor.id=WorkflowStatus)")
    private ModelPreFilterContributor _workflowStatusModelPreFilterContributor;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addCustomObjectDefinition(long userId, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, Map<Locale, String> pluralLabelMap, String scope, List<ObjectField> objectFields) throws PortalException {
        return this._addObjectDefinition(userId, null, null, labelMap, name, panelAppOrder, panelCategoryKey, null, null, pluralLabelMap, scope, false, 0, 2, objectFields);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addOrUpdateSystemObjectDefinition(long companyId, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByC_N(companyId, systemObjectDefinitionMetadata.getName());
        if (objectDefinition != null && objectDefinition.getVersion() == systemObjectDefinitionMetadata.getVersion()) {
            return objectDefinition;
        }
        long userId = this._userLocalService.getDefaultUserId(companyId);
        if (objectDefinition == null) {
            Table table = systemObjectDefinitionMetadata.getTable();
            Column primaryKeyColumn = systemObjectDefinitionMetadata.getPrimaryKeyColumn();
            return this.addSystemObjectDefinition(userId, systemObjectDefinitionMetadata.getClassName(), table.getTableName(), systemObjectDefinitionMetadata.getLabelMap(), systemObjectDefinitionMetadata.getName(), primaryKeyColumn.getName(), primaryKeyColumn.getName(), systemObjectDefinitionMetadata.getPluralLabelMap(), systemObjectDefinitionMetadata.getScope(), systemObjectDefinitionMetadata.getVersion(), systemObjectDefinitionMetadata.getObjectFields());
        }
        objectDefinition.setVersion(systemObjectDefinitionMetadata.getVersion());
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        List newObjectFields = systemObjectDefinitionMetadata.getObjectFields();
        List oldObjectFields = this._objectFieldPersistence.findByODI_DTN(objectDefinition.getObjectDefinitionId(), objectDefinition.getDBTableName());
        for (ObjectField oldObjectField : oldObjectFields) {
            if (this._hasObjectField(newObjectFields, oldObjectField)) continue;
            this._objectFieldPersistence.remove((BaseModel)oldObjectField);
        }
        for (ObjectField newObjectField : newObjectFields) {
            ObjectField oldObjectField = this._objectFieldPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), newObjectField.getName());
            if (oldObjectField == null) {
                this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), newObjectField.getDBColumnName(), false, false, "", newObjectField.getLabelMap(), newObjectField.getName(), newObjectField.isRequired(), newObjectField.getType());
                continue;
            }
            if (Objects.equals(oldObjectField, newObjectField.getType())) continue;
            oldObjectField.setRequired(newObjectField.isRequired());
            oldObjectField.setType(newObjectField.getType());
            this._objectFieldPersistence.update((BaseModel)oldObjectField);
        }
        return objectDefinition;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addSystemObjectDefinition(long userId, String className, String dbTableName, Map<Locale, String> labelMap, String name, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope, int version, List<ObjectField> objectFields) throws PortalException {
        return this._addObjectDefinition(userId, className, dbTableName, labelMap, name, null, null, pkObjectFieldDBColumnName, pkObjectFieldName, pluralLabelMap, scope, true, version, 0, objectFields);
    }

    public void deleteCompanyObjectDefinitions(long companyId) throws PortalException {
        List objectDefinitions = this.objectDefinitionPersistence.findByCompanyId(companyId);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            this.objectDefinitionLocalService.deleteObjectDefinition(objectDefinition);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectDefinition deleteObjectDefinition(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return this.deleteObjectDefinition(objectDefinition);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectDefinition deleteObjectDefinition(ObjectDefinition objectDefinition) throws PortalException {
        if (!CompanyThreadLocal.isDeleteInProcess() && !PortalRunMode.isTestMode() && objectDefinition.isApproved()) {
            throw new RequiredObjectDefinitionException();
        }
        if (!objectDefinition.isSystem()) {
            List objectEntries = this._objectEntryPersistence.findByObjectDefinitionId(objectDefinition.getObjectDefinitionId());
            for (ObjectEntry objectEntry : objectEntries) {
                this._objectEntryLocalService.deleteObjectEntry(objectEntry);
            }
        }
        this._objectFieldPersistence.removeByObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        this.objectDefinitionPersistence.remove((BaseModel)objectDefinition);
        this._resourceLocalService.deleteResource(objectDefinition.getCompanyId(), ObjectDefinition.class.getName(), 4, objectDefinition.getObjectDefinitionId());
        if (objectDefinition.isSystem()) {
            this._dropTable(objectDefinition.getExtensionDBTableName());
        } else if (objectDefinition.isApproved()) {
            for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(objectDefinition.getClassName())) {
                this._resourceActionLocalService.deleteResourceAction(resourceAction);
            }
            for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(objectDefinition.getPortletId())) {
                this._resourceActionLocalService.deleteResourceAction(resourceAction);
            }
            for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(objectDefinition.getResourceName())) {
                this._resourceActionLocalService.deleteResourceAction(resourceAction);
            }
            this._dropTable(objectDefinition.getDBTableName());
            this._dropTable(objectDefinition.getExtensionDBTableName());
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this.objectDefinitionLocalService.undeployObjectDefinition(objectDefinition);
                return null;
            });
        }
        return objectDefinition;
    }

    @Clusterable
    public void deployObjectDefinition(ObjectDefinition objectDefinition) {
        if (objectDefinition.isSystem()) {
            return;
        }
        this.undeployObjectDefinition(objectDefinition);
        for (Map.Entry<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> entry : this._serviceRegistrationsMaps.entrySet()) {
            ObjectDefinitionDeployer objectDefinitionDeployer = entry.getKey();
            Map<Long, List<ServiceRegistration<?>>> serviceRegistrationsMap = entry.getValue();
            serviceRegistrationsMap.computeIfAbsent(objectDefinition.getObjectDefinitionId(), objectDefinitionId -> objectDefinitionDeployer.deploy(objectDefinition));
        }
    }

    public ObjectDefinition fetchObjectDefinition(long companyId, String name) {
        return this.objectDefinitionPersistence.fetchByC_N(companyId, name);
    }

    public ObjectDefinition fetchObjectDefinitionByClassName(long companyId, String className) throws PortalException {
        return this.objectDefinitionPersistence.fetchByC_C(companyId, className);
    }

    public List<ObjectDefinition> getCustomObjectDefinitions(int status) {
        return this.objectDefinitionPersistence.findByS_S(false, status);
    }

    @Override
    public ObjectDefinition getObjectDefinition(long objectDefinitionId) throws PortalException {
        return this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, boolean active, boolean system, int status) {
        return this.objectDefinitionPersistence.findByC_A_S_S(companyId, active, system, status);
    }

    public int getObjectDefinitionsCount(long companyId) throws PortalException {
        return this.objectDefinitionPersistence.countByCompanyId(companyId);
    }

    public List<ObjectDefinition> getSystemObjectDefinitions() {
        return this.objectDefinitionPersistence.findBySystem(true);
    }

    public ObjectDefinition publishCustomObjectDefinition(long userId, long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isSystem()) {
            throw new ObjectDefinitionStatusException();
        }
        objectDefinition.setStatus(0);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._createTable(objectDefinition.getDBTableName(), objectDefinition);
        this._createTable(objectDefinition.getExtensionDBTableName(), objectDefinition);
        ObjectDefinition finalObjectDefinition = objectDefinition;
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this.objectDefinitionLocalService.deployObjectDefinition(finalObjectDefinition);
            return null;
        });
        return objectDefinition;
    }

    @Override
    public void setAopProxy(Object aopProxy) {
        super.setAopProxy(aopProxy);
        this._addingObjectDefinitionDeployer(new ObjectDefinitionDeployerImpl(this._bundleContext, this._dynamicQueryBatchIndexingActionableFactory, this._listTypeEntryLocalService, this._modelSearchRegistrarHelper, this, this._objectEntryLocalService, this._objectFieldLocalService, this._objectRelationshipLocalService, this._objectScopeProviderRegistry, this._persistedModelLocalServiceRegistry, this._resourceActions, this._workflowStatusModelPreFilterContributor));
        this._objectDefinitionDeployerServiceTracker = new ServiceTracker(this._bundleContext, ObjectDefinitionDeployer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ObjectDefinitionDeployer, ObjectDefinitionDeployer>(){

            public ObjectDefinitionDeployer addingService(ServiceReference<ObjectDefinitionDeployer> serviceReference) {
                return ObjectDefinitionLocalServiceImpl.this._addingObjectDefinitionDeployer((ObjectDefinitionDeployer)ObjectDefinitionLocalServiceImpl.this._bundleContext.getService(serviceReference));
            }

            public void modifiedService(ServiceReference<ObjectDefinitionDeployer> serviceReference, ObjectDefinitionDeployer objectDefinitionDeployer) {
            }

            public void removedService(ServiceReference<ObjectDefinitionDeployer> serviceReference, ObjectDefinitionDeployer objectDefinitionDeployer) {
                Map serviceRegistrationsMap = (Map)ObjectDefinitionLocalServiceImpl.this._serviceRegistrationsMaps.remove(objectDefinitionDeployer);
                for (List serviceRegistrations : serviceRegistrationsMap.values()) {
                    for (ServiceRegistration serviceRegistration : serviceRegistrations) {
                        serviceRegistration.unregister();
                    }
                }
                ObjectDefinitionLocalServiceImpl.this._bundleContext.ungetService(serviceReference);
            }
        });
        this._objectDefinitionDeployerServiceTracker.open();
    }

    @Clusterable
    public void undeployObjectDefinition(ObjectDefinition objectDefinition) {
        if (objectDefinition.isSystem()) {
            return;
        }
        for (Map.Entry<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> entry : this._serviceRegistrationsMaps.entrySet()) {
            ObjectDefinitionDeployer objectDefinitionDeployer = entry.getKey();
            objectDefinitionDeployer.undeploy(objectDefinition);
            Map<Long, List<ServiceRegistration<?>>> serviceRegistrationsMap = entry.getValue();
            List<ServiceRegistration<?>> serviceRegistrations = serviceRegistrationsMap.remove(objectDefinition.getObjectDefinitionId());
            if (serviceRegistrations == null) continue;
            for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateCustomObjectDefinition(Long objectDefinitionId, long descriptionObjectFieldId, long titleObjectFieldId, boolean active, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, Map<Locale, String> pluralLabelMap, String scope) throws PortalException {
        ObjectDefinition objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.fetchByPrimaryKey((Serializable)objectDefinitionId);
        if (objectDefinition.isSystem()) {
            throw new ObjectDefinitionStatusException();
        }
        return this._updateObjectDefinition(objectDefinition, descriptionObjectFieldId, titleObjectFieldId, active, null, labelMap, name, panelAppOrder, panelCategoryKey, null, null, pluralLabelMap, scope);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        if (this._objectDefinitionDeployerServiceTracker != null) {
            this._objectDefinitionDeployerServiceTracker.close();
        }
    }

    private ObjectDefinitionDeployer _addingObjectDefinitionDeployer(ObjectDefinitionDeployer objectDefinitionDeployer) {
        ConcurrentHashMap<Long, List> serviceRegistrationsMap = new ConcurrentHashMap<Long, List>();
        List objectDefinitions = this.objectDefinitionLocalService.getCustomObjectDefinitions(0);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            serviceRegistrationsMap.put(objectDefinition.getObjectDefinitionId(), objectDefinitionDeployer.deploy(objectDefinition));
        }
        this._serviceRegistrationsMaps.put(objectDefinitionDeployer, serviceRegistrationsMap);
        return objectDefinitionDeployer;
    }

    private ObjectDefinition _addObjectDefinition(long userId, String className, String dbTableName, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope, boolean system, int version, int status, List<ObjectField> objectFields) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        name = this._getName(name, system);
        String shortName = ObjectDefinitionImpl.getShortName(name);
        dbTableName = this._getDBTableName(dbTableName, name, system, user.getCompanyId(), shortName);
        pkObjectFieldName = this._getPKObjectFieldName(pkObjectFieldName, system, shortName);
        pkObjectFieldDBColumnName = this._getPKObjectFieldDBColumnName(pkObjectFieldDBColumnName, pkObjectFieldName, system);
        this._validateLabel(labelMap, LocaleUtil.getSiteDefault());
        this._validateName(0L, user.getCompanyId(), name, system);
        this._validatePluralLabel(pluralLabelMap, LocaleUtil.getSiteDefault());
        this._validateScope(scope);
        this._validateVersion(system, version);
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.create(this.counterLocalService.increment());
        objectDefinition.setCompanyId(user.getCompanyId());
        objectDefinition.setUserId(user.getUserId());
        objectDefinition.setUserName(user.getFullName());
        objectDefinition.setActive(true);
        objectDefinition.setDBTableName(dbTableName);
        objectDefinition.setClassName(this._getClassName(objectDefinition.getObjectDefinitionId(), className, system));
        objectDefinition.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectDefinition.setName(name);
        objectDefinition.setPanelAppOrder(panelAppOrder);
        objectDefinition.setPanelCategoryKey(panelCategoryKey);
        objectDefinition.setPKObjectFieldDBColumnName(pkObjectFieldDBColumnName);
        objectDefinition.setPKObjectFieldName(pkObjectFieldName);
        objectDefinition.setPluralLabelMap(pluralLabelMap);
        objectDefinition.setScope(scope);
        objectDefinition.setSystem(system);
        objectDefinition.setVersion(version);
        objectDefinition.setStatus(status);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._resourceLocalService.addResources(objectDefinition.getCompanyId(), 0L, objectDefinition.getUserId(), ObjectDefinition.class.getName(), objectDefinition.getObjectDefinitionId(), false, true, true);
        if (objectFields != null) {
            for (ObjectField objectField : objectFields) {
                if (system) {
                    this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), objectField.getDBColumnName(), objectField.isIndexed(), objectField.isIndexedAsKeyword(), objectField.getIndexedLanguageId(), objectField.getLabelMap(), objectField.getName(), objectField.isRequired(), objectField.getType());
                    continue;
                }
                this._objectFieldLocalService.addCustomObjectField(userId, objectField.getListTypeDefinitionId(), objectDefinition.getObjectDefinitionId(), objectField.isIndexed(), objectField.isIndexedAsKeyword(), objectField.getIndexedLanguageId(), objectField.getLabelMap(), objectField.getName(), objectField.isRequired(), objectField.getType());
            }
        }
        if (system) {
            this._createTable(objectDefinition.getExtensionDBTableName(), objectDefinition);
        }
        return objectDefinition;
    }

    private void _createTable(String dbTableName, ObjectDefinition objectDefinition) {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldPersistence.findByODI_DTN(objectDefinition.getObjectDefinitionId(), dbTableName), dbTableName);
        this.runSQL(dynamicObjectDefinitionTable.getCreateTableSQL());
    }

    private void _deleteWorkflowInstanceLinks(ObjectDefinition objectDefinition) throws PortalException {
        List objectEntries = this._objectEntryPersistence.findByODI_NotS(objectDefinition.getObjectDefinitionId(), 0);
        for (ObjectEntry objectEntry : objectEntries) {
            this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(objectEntry.getCompanyId(), objectEntry.getNonzeroGroupId(), objectDefinition.getClassName(), objectEntry.getObjectEntryId());
        }
    }

    private void _dropTable(String dbTableName) {
        String sql = "drop table " + dbTableName;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        this.runSQL(sql);
    }

    private String _getClassName(long objectDefinitionId, String className, boolean system) {
        if (system) {
            return className;
        }
        return "com.liferay.object.model.ObjectDefinition#" + objectDefinitionId;
    }

    private String _getDBTableName(String dbTableName, String name, boolean system, Long companyId, String shortName) {
        if (Validator.isNotNull((String)dbTableName)) {
            return dbTableName;
        }
        if (system) {
            return name;
        }
        return StringBundler.concat((Object[])new Object[]{"O_", companyId, "_", shortName});
    }

    private String _getName(String name, boolean system) {
        name = StringUtil.trim((String)name);
        if (!system) {
            name = "C_" + name;
        }
        return name;
    }

    private String _getPKObjectFieldDBColumnName(String pkObjectFieldDBColumnName, String pkObjectFieldName, boolean system) {
        if (Validator.isNotNull((String)pkObjectFieldDBColumnName)) {
            return pkObjectFieldDBColumnName;
        }
        if (system) {
            return pkObjectFieldName;
        }
        return pkObjectFieldName + "_";
    }

    private String _getPKObjectFieldName(String pkObjectFieldName, boolean system, String shortName) {
        if (Validator.isNotNull((String)pkObjectFieldName)) {
            return pkObjectFieldName;
        }
        pkObjectFieldName = TextFormatter.format((String)(shortName + "Id"), (int)8);
        if (system) {
            return pkObjectFieldName;
        }
        pkObjectFieldName = "c_" + pkObjectFieldName;
        return pkObjectFieldName;
    }

    private boolean _hasObjectField(List<ObjectField> newObjectFields, ObjectField oldObjectField) {
        for (ObjectField newObjectField : newObjectFields) {
            if (!Objects.equals(newObjectField.getName(), oldObjectField.getName())) continue;
            return true;
        }
        return false;
    }

    private void _startWorkflowInstanceLinks(ObjectDefinition objectDefinition) throws PortalException {
        List objectEntries = this._objectEntryPersistence.findByODI_NotS(objectDefinition.getObjectDefinitionId(), 0);
        for (ObjectEntry objectEntry : objectEntries) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)objectEntry.getCompanyId(), (long)objectEntry.getNonzeroGroupId(), (long)objectEntry.getUserId(), (String)objectDefinition.getClassName(), (long)objectEntry.getObjectEntryId(), (Object)objectEntry, (ServiceContext)ServiceContextThreadLocal.getServiceContext());
        }
    }

    private ObjectDefinition _updateObjectDefinition(ObjectDefinition objectDefinition, long descriptionObjectFieldId, long titleObjectFieldId, boolean active, String dbTableName, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope) throws PortalException {
        boolean originalActive = objectDefinition.isActive();
        this._validateObjectFieldId(objectDefinition, descriptionObjectFieldId);
        this._validateObjectFieldId(objectDefinition, titleObjectFieldId);
        this._validateLabel(labelMap, LocaleUtil.getSiteDefault());
        this._validatePluralLabel(pluralLabelMap, LocaleUtil.getSiteDefault());
        objectDefinition.setDescriptionObjectFieldId(descriptionObjectFieldId);
        objectDefinition.setTitleObjectFieldId(titleObjectFieldId);
        objectDefinition.setActive(active);
        objectDefinition.setPanelAppOrder(panelAppOrder);
        objectDefinition.setPanelCategoryKey(panelCategoryKey);
        objectDefinition.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectDefinition.setPluralLabelMap(pluralLabelMap);
        if (objectDefinition.isApproved()) {
            if (!active && originalActive) {
                this._deleteWorkflowInstanceLinks(objectDefinition);
                this.objectDefinitionLocalService.undeployObjectDefinition(objectDefinition);
            } else if (active) {
                this.objectDefinitionLocalService.deployObjectDefinition(objectDefinition);
                this._startWorkflowInstanceLinks(objectDefinition);
            }
            return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
        name = this._getName(name, objectDefinition.isSystem());
        String shortName = ObjectDefinitionImpl.getShortName(name);
        dbTableName = this._getDBTableName(dbTableName, name, objectDefinition.isSystem(), objectDefinition.getCompanyId(), shortName);
        pkObjectFieldName = this._getPKObjectFieldName(pkObjectFieldName, objectDefinition.isSystem(), shortName);
        pkObjectFieldDBColumnName = this._getPKObjectFieldDBColumnName(pkObjectFieldDBColumnName, pkObjectFieldName, objectDefinition.isSystem());
        this._validateName(objectDefinition.getObjectDefinitionId(), objectDefinition.getCompanyId(), name, objectDefinition.isSystem());
        this._validateScope(scope);
        objectDefinition.setDBTableName(dbTableName);
        objectDefinition.setName(name);
        objectDefinition.setPKObjectFieldDBColumnName(pkObjectFieldDBColumnName);
        objectDefinition.setPKObjectFieldName(pkObjectFieldName);
        objectDefinition.setScope(scope);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    private void _validateLabel(Map<Locale, String> labelMap, Locale defaultLocale) throws PortalException {
        if (labelMap == null || Validator.isNull((String)labelMap.get(defaultLocale))) {
            throw new ObjectDefinitionLabelException("Label is null for locale " + defaultLocale.getDisplayName());
        }
    }

    private void _validateName(long objectDefinitionId, long companyId, String name, boolean system) throws PortalException {
        if (Validator.isNull((String)name) || !system && name.equals("C_")) {
            throw new ObjectDefinitionNameException("Name is null");
        }
        if (system && (name.startsWith("C_") || name.startsWith("c_"))) {
            throw new ObjectDefinitionNameException("System object definition names must not start with \"C_\"");
        }
        if (!system && !name.startsWith("C_")) {
            throw new ObjectDefinitionNameException("Custom object definition names must start with \"C_\"");
        }
        char[] nameCharArray = name.toCharArray();
        for (int i = 0; i < nameCharArray.length; ++i) {
            char c;
            if (!system && (i == 0 || i == 1) || Validator.isChar((char)(c = nameCharArray[i])) || Validator.isDigit((char)c)) continue;
            throw new ObjectDefinitionNameException("Name must only contain letters and digits");
        }
        if (system && !Character.isUpperCase(nameCharArray[0]) || !system && !Character.isUpperCase(nameCharArray[2])) {
            throw new ObjectDefinitionNameException("The first character of a name must be an upper case letter");
        }
        if (system && nameCharArray.length > 41 || !system && nameCharArray.length > 43) {
            throw new ObjectDefinitionNameException("Names must be less than 41 characters");
        }
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByC_N(companyId, name);
        if (objectDefinition != null && objectDefinition.getObjectDefinitionId() != objectDefinitionId) {
            throw new DuplicateObjectDefinitionException("Duplicate name " + name);
        }
    }

    private void _validateObjectFieldId(ObjectDefinition objectDefinition, long objectFieldId) throws PortalException {
        if (objectFieldId <= 0L) {
            return;
        }
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectFieldId);
        if (objectField == null || objectField.getObjectDefinitionId() != objectDefinition.getObjectDefinitionId()) {
            throw new NoSuchObjectFieldException();
        }
    }

    private void _validatePluralLabel(Map<Locale, String> pluralLabelMap, Locale defaultLocale) throws PortalException {
        if (pluralLabelMap == null || Validator.isNull((String)pluralLabelMap.get(defaultLocale))) {
            throw new ObjectDefinitionPluralLabelException("Plural label is null for locale " + defaultLocale.getDisplayName());
        }
    }

    private void _validateScope(String scope) throws PortalException {
        if (Validator.isNull((String)scope)) {
            throw new ObjectDefinitionScopeException("Scope is null");
        }
        try {
            this._objectScopeProviderRegistry.getObjectScopeProvider(scope);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjectDefinitionScopeException(illegalArgumentException.getMessage());
        }
    }

    private void _validateVersion(boolean system, int version) throws PortalException {
        if (system) {
            if (version <= 0) {
                throw new ObjectDefinitionVersionException("System object definition versions must greater than 0");
            }
        } else if (version != 0) {
            throw new ObjectDefinitionVersionException("Custom object definition versions must be 0");
        }
    }
}

