/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.persistence.impl;

import com.liferay.object.model.ObjectLayoutColumnTable;
import com.liferay.object.model.impl.ObjectLayoutColumnImpl;
import com.liferay.object.model.impl.ObjectLayoutColumnModelImpl;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ObjectLayoutColumnModelArgumentsResolver.class, ArgumentsResolver.class})
public class ObjectLayoutColumnModelArgumentsResolver
implements ArgumentsResolver {
    private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

    public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
        String[] columnNames = finderPath.getColumnNames();
        if (columnNames == null || columnNames.length == 0) {
            if (baseModel.isNew()) {
                return new Object[0];
            }
            return null;
        }
        ObjectLayoutColumnModelImpl objectLayoutColumnModelImpl = (ObjectLayoutColumnModelImpl)baseModel;
        long columnBitmask = objectLayoutColumnModelImpl.getColumnBitmask();
        if (!checkColumn || columnBitmask == 0L) {
            return ObjectLayoutColumnModelArgumentsResolver._getValue(objectLayoutColumnModelImpl, columnNames, original);
        }
        Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
        if (finderPathColumnBitmask == null) {
            finderPathColumnBitmask = 0L;
            for (String columnName : columnNames) {
                finderPathColumnBitmask = finderPathColumnBitmask | ObjectLayoutColumnModelImpl.getColumnBitmask(columnName);
            }
            _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
        }
        if ((columnBitmask & finderPathColumnBitmask) != 0L) {
            return ObjectLayoutColumnModelArgumentsResolver._getValue(objectLayoutColumnModelImpl, columnNames, original);
        }
        return null;
    }

    public String getClassName() {
        return ObjectLayoutColumnImpl.class.getName();
    }

    public String getTableName() {
        return ObjectLayoutColumnTable.INSTANCE.getTableName();
    }

    private static Object[] _getValue(ObjectLayoutColumnModelImpl objectLayoutColumnModelImpl, String[] columnNames, boolean original) {
        Object[] arguments = new Object[columnNames.length];
        for (int i = 0; i < arguments.length; ++i) {
            String columnName = columnNames[i];
            arguments[i] = original ? objectLayoutColumnModelImpl.getColumnOriginalValue(columnName) : objectLayoutColumnModelImpl.getColumnValue(columnName);
        }
        return arguments;
    }
}

