/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.ObjectValidationException;
import com.liferay.object.model.ObjectValidationRule;
import com.liferay.object.service.base.ObjectValidationRuleLocalServiceBaseImpl;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.object.validation.rule.ObjectValidationRuleEngineServicesTracker;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectValidationRule"}, service={AopService.class})
public class ObjectValidationRuleLocalServiceImpl
extends ObjectValidationRuleLocalServiceBaseImpl {
    @Reference
    private ObjectValidationRuleEngineServicesTracker _objectValidationRuleEngineServicesTracker;
    @Reference
    private UserLocalService _userLocalService;

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId, boolean active, int start, int end) {
        return this.objectValidationRulePersistence.findByODI_A(objectDefinitionId, active, start, end);
    }

    public void validate(long userId, long objectDefinitionId, BaseModel<?> originalBaseModel, BaseModel<?> baseModel) throws PortalException {
        List objectValidationRules = this.objectValidationRuleLocalService.getObjectValidationRules(objectDefinitionId, true, -1, -1);
        for (ObjectValidationRule objectValidationRule : objectValidationRules) {
            ObjectValidationRuleEngine objectValidationRuleEngine = this._objectValidationRuleEngineServicesTracker.getObjectValidationRuleEngine(objectValidationRule.getEngine());
            HashMapBuilder.HashMapWrapper hashMapWrapper = HashMapBuilder.putAll((Map)baseModel.getModelAttributes());
            if (originalBaseModel != null) {
                Map modelAttributes = originalBaseModel.getModelAttributes();
                for (Map.Entry entry : modelAttributes.entrySet()) {
                    hashMapWrapper.put((Object)("original." + (String)entry.getKey()), entry.getValue());
                }
            }
            if (userId > 0L) {
                User user = this._userLocalService.getUser(userId);
                hashMapWrapper.put((Object)"user.emailAddress", (Object)user.getEmailAddress()).put((Object)"user.firstName", (Object)user.getFirstName()).put((Object)"user.lastName", (Object)user.getLastName()).put((Object)"userId", (Object)userId);
            }
            if (objectValidationRuleEngine.evaluate((Map)hashMapWrapper.build(), objectValidationRule.getScript())) continue;
            throw new ObjectValidationException(objectValidationRule.getErrorLabel(LocaleUtil.getMostRelevantLocale()));
        }
    }
}

