/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.DefaultObjectViewException;
import com.liferay.object.exception.ObjectViewSortColumnException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectView;
import com.liferay.object.model.ObjectViewColumn;
import com.liferay.object.model.ObjectViewSortColumn;
import com.liferay.object.service.base.ObjectViewLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectViewColumnPersistence;
import com.liferay.object.service.persistence.ObjectViewSortColumnPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectView"}, service={AopService.class})
public class ObjectViewLocalServiceImpl
extends ObjectViewLocalServiceBaseImpl {
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectViewColumnPersistence _objectViewColumnPersistence;
    @Reference
    private ObjectViewSortColumnPersistence _objectViewSortColumnPersistence;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectView addObjectView(long userId, long objectDefinitionId, boolean defaultObjectView, Map<Locale, String> nameMap, List<ObjectViewColumn> objectViewColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (defaultObjectView) {
            this._validate(0L, objectDefinitionId);
        }
        ObjectView objectView = this.objectViewPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectView.setCompanyId(user.getCompanyId());
        objectView.setUserId(user.getUserId());
        objectView.setUserName(user.getFullName());
        objectView.setObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        objectView.setDefaultObjectView(defaultObjectView);
        objectView.setNameMap(nameMap);
        objectView = (ObjectView)this.objectViewPersistence.update((BaseModel)objectView);
        objectView.setObjectViewColumns(this._addObjectViewColumns(user, objectView.getObjectViewId(), objectViewColumns));
        objectView.setObjectViewSortColumns(this._addObjectViewSortColumns(user, objectView, objectViewColumns, objectViewSortColumns));
        return objectView;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectView deleteObjectView(long objectViewId) throws PortalException {
        return this.deleteObjectView(this.objectViewPersistence.findByPrimaryKey(objectViewId));
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectView deleteObjectView(ObjectView objectView) {
        objectView = (ObjectView)this.objectViewPersistence.remove((BaseModel)objectView);
        this._objectViewColumnPersistence.removeByObjectViewId(objectView.getObjectViewId());
        this._objectViewSortColumnPersistence.removeByObjectViewId(objectView.getObjectViewId());
        return objectView;
    }

    public ObjectView fetchDefaultObjectView(long objectDefinitionId) {
        ObjectView objectView = this.objectViewPersistence.fetchByODI_DOV_First(objectDefinitionId, true, null);
        if (objectView != null) {
            objectView.setObjectViewColumns(this._objectViewColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
            objectView.setObjectViewSortColumns(this._objectViewSortColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        }
        return objectView;
    }

    @Override
    public ObjectView getObjectView(long objectViewId) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        objectView.setObjectViewColumns(this._objectViewColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        objectView.setObjectViewSortColumns(this._objectViewSortColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        return objectView;
    }

    public List<ObjectView> getObjectViews(long objectDefinitionId) {
        List objectViews = this.objectViewPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectView objectView : objectViews) {
            objectView.setObjectViewColumns(this._objectViewColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
            objectView.setObjectViewSortColumns(this._objectViewSortColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        }
        return objectViews;
    }

    public void unassociateObjectField(ObjectField objectField) {
        List objectViews = this.objectViewPersistence.findByObjectDefinitionId(objectField.getObjectDefinitionId());
        for (ObjectView objectView : objectViews) {
            this._objectViewColumnPersistence.removeByOVI_OFN(objectView.getObjectViewId(), objectField.getName());
            this._objectViewSortColumnPersistence.removeByOVI_OFN(objectView.getObjectViewId(), objectField.getName());
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectView updateObjectView(long objectViewId, boolean defaultObjectView, Map<Locale, String> nameMap, List<ObjectViewColumn> objectViewColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        if (defaultObjectView) {
            this._validate(objectViewId, objectView.getObjectDefinitionId());
        }
        this._objectViewColumnPersistence.removeByObjectViewId(objectView.getObjectViewId());
        this._objectViewSortColumnPersistence.removeByObjectViewId(objectView.getObjectViewId());
        objectView.setDefaultObjectView(defaultObjectView);
        objectView.setNameMap(nameMap);
        objectView = (ObjectView)this.objectViewPersistence.update((BaseModel)objectView);
        objectView.setObjectViewColumns(this._addObjectViewColumns(this._userLocalService.getUser(objectView.getUserId()), objectView.getObjectViewId(), objectViewColumns));
        objectView.setObjectViewSortColumns(this._addObjectViewSortColumns(this._userLocalService.getUser(objectView.getUserId()), objectView, objectViewColumns, objectViewSortColumns));
        return objectView;
    }

    private List<ObjectViewColumn> _addObjectViewColumns(User user, long objectViewId, List<ObjectViewColumn> objectViewColumns) {
        return TransformUtil.transform(objectViewColumns, objectViewColumn -> {
            ObjectViewColumn newObjectViewColumn = this._objectViewColumnPersistence.create(this.counterLocalService.increment());
            newObjectViewColumn.setCompanyId(user.getCompanyId());
            newObjectViewColumn.setUserId(user.getUserId());
            newObjectViewColumn.setUserName(user.getFullName());
            newObjectViewColumn.setObjectViewId(objectViewId);
            newObjectViewColumn.setLabelMap(objectViewColumn.getLabelMap());
            newObjectViewColumn.setObjectFieldName(objectViewColumn.getObjectFieldName());
            newObjectViewColumn.setPriority(objectViewColumn.getPriority());
            return (ObjectViewColumn)this._objectViewColumnPersistence.update((BaseModel)newObjectViewColumn);
        });
    }

    private List<ObjectViewSortColumn> _addObjectViewSortColumns(User user, ObjectView objectView, List<ObjectViewColumn> objectViewColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws ObjectViewSortColumnException {
        try {
            this._validate(objectViewColumns, objectViewSortColumns);
        }
        catch (ObjectViewSortColumnException objectViewSortColumnException) {
            throw new ObjectViewSortColumnException(objectViewSortColumnException.getMessage());
        }
        return TransformUtil.transform(objectViewSortColumns, objectViewSortColumn -> {
            ObjectViewSortColumn newObjectViewSortColumn = this._objectViewSortColumnPersistence.create(this.counterLocalService.increment());
            newObjectViewSortColumn.setCompanyId(user.getCompanyId());
            newObjectViewSortColumn.setUserId(user.getUserId());
            newObjectViewSortColumn.setUserName(user.getFullName());
            newObjectViewSortColumn.setObjectViewId(objectView.getObjectViewId());
            newObjectViewSortColumn.setObjectFieldName(objectViewSortColumn.getObjectFieldName());
            newObjectViewSortColumn.setPriority(objectViewSortColumn.getPriority());
            newObjectViewSortColumn.setSortOrder(objectViewSortColumn.getSortOrder());
            return (ObjectViewSortColumn)this._objectViewSortColumnPersistence.update((BaseModel)newObjectViewSortColumn);
        });
    }

    private void _validate(List<ObjectViewColumn> objectViewColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws ObjectViewSortColumnException {
        Set objectFieldNames = SetUtil.fromArray((Object[])new String[]{"creator", "dateCreated", "dateModified", "id", "status"});
        for (ObjectViewColumn objectViewColumn : objectViewColumns) {
            objectFieldNames.add(objectViewColumn.getObjectFieldName());
        }
        for (ObjectViewSortColumn objectViewSortColumn : objectViewSortColumns) {
            if (!objectFieldNames.contains(objectViewSortColumn.getObjectFieldName())) {
                throw new ObjectViewSortColumnException("There is no object field with the name: " + objectViewSortColumn.getObjectFieldName());
            }
            if (StringUtil.equals((String)objectViewSortColumn.getSortOrder(), (String)"asc") || StringUtil.equals((String)objectViewSortColumn.getSortOrder(), (String)"desc")) continue;
            throw new ObjectViewSortColumnException("There is no sort order of type: " + objectViewSortColumn.getSortOrder());
        }
    }

    private void _validate(long objectViewId, long objectDefinitionId) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.fetchByODI_DOV_First(objectDefinitionId, true, null);
        if (objectView != null && objectView.getObjectViewId() != objectViewId) {
            throw new DefaultObjectViewException("There can only be one default object view");
        }
    }
}

