/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.process.local;

import com.liferay.petra.concurrent.AsyncBroker;
import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.local.RequestProcessCallable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

class LocalProcessChannel<T extends Serializable>
implements ProcessChannel<T> {
    private final AsyncBroker<Long, Serializable> _asyncBroker;
    private final AtomicLong _idGenerator = new AtomicLong();
    private final NoticeableFuture<T> _noticeableFuture;
    private final ObjectOutputStream _objectOutputStream;

    LocalProcessChannel(NoticeableFuture<T> noticeableFuture, ObjectOutputStream objectOutputStream, AsyncBroker<Long, Serializable> asyncBroker) {
        this._noticeableFuture = noticeableFuture;
        this._objectOutputStream = objectOutputStream;
        this._asyncBroker = asyncBroker;
        this._noticeableFuture.addFutureListener(new FutureListener<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete(Future<T> future) {
                try {
                    LocalProcessChannel.this._objectOutputStream.close();
                }
                catch (IOException map) {
                    Map map2 = LocalProcessChannel.this._asyncBroker.getOpenBids();
                    for (NoticeableFuture noticeableFuture : map2.values()) {
                        noticeableFuture.cancel(true);
                    }
                }
                finally {
                    Map map = LocalProcessChannel.this._asyncBroker.getOpenBids();
                    for (NoticeableFuture noticeableFuture : map.values()) {
                        noticeableFuture.cancel(true);
                    }
                }
            }
        });
    }

    @Override
    public NoticeableFuture<T> getProcessNoticeableFuture() {
        return this._noticeableFuture;
    }

    @Override
    public <V extends Serializable> NoticeableFuture<V> write(ProcessCallable<V> processCallable) {
        long id = this._idGenerator.getAndIncrement();
        NoticeableFuture noticeableFuture = this._asyncBroker.post((Object)id);
        try {
            this._objectOutputStream.writeObject(new RequestProcessCallable<V>(id, processCallable));
            this._objectOutputStream.flush();
        }
        catch (IOException ioe) {
            this._asyncBroker.takeWithException((Object)id, (Throwable)ioe);
        }
        return noticeableFuture;
    }
}

