/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.process;

import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.petra.process.OutputProcessor;
import com.liferay.petra.process.ProcessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;

public class LoggingOutputProcessor
implements OutputProcessor<Void, Void> {
    private final Charset _charset;
    private final BiConsumer<Boolean, String> _logLineConsumer;

    public LoggingOutputProcessor(BiConsumer<Boolean, String> logLineConsumer) {
        this(Charset.defaultCharset(), logLineConsumer);
    }

    public LoggingOutputProcessor(Charset charset, BiConsumer<Boolean, String> logLineConsumer) {
        this._charset = charset;
        this._logLineConsumer = logLineConsumer;
    }

    @Override
    public Void processStdErr(InputStream stdErrInputStream) throws ProcessException {
        this._processOut(true, stdErrInputStream);
        return null;
    }

    @Override
    public Void processStdOut(InputStream stdOutInputStream) throws ProcessException {
        this._processOut(false, stdOutInputStream);
        return null;
    }

    private void _processOut(boolean stdErr, InputStream inputStream) throws ProcessException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(inputStream, this._charset));
        String line = null;
        try {
            while ((line = unsyncBufferedReader.readLine()) != null) {
                this._logLineConsumer.accept(stdErr, line);
            }
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
        finally {
            try {
                unsyncBufferedReader.close();
            }
            catch (IOException ioe) {
                throw new ProcessException(ioe);
            }
        }
    }
}

