/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.process;

import com.liferay.petra.process.PathHolder;
import com.liferay.petra.process.ProcessLog;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ProcessConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> _arguments;
    private final PathHolder[] _bootstrapClassPathHolders;
    private final Map<String, String> _environment;
    private final String _javaExecutable;
    private final transient Consumer<ProcessLog> _processLogConsumer;
    private final transient ClassLoader _reactClassLoader;
    private final PathHolder[] _runtimeClassPathHolders;

    public List<String> getArguments() {
        return this._arguments;
    }

    public String getBootstrapClassPath() {
        return this._merge(this.getBootstrapClassPathHolders());
    }

    public PathHolder[] getBootstrapClassPathHolders() {
        return this._bootstrapClassPathHolders;
    }

    public Map<String, String> getEnvironment() {
        return this._environment;
    }

    public String getJavaExecutable() {
        return this._javaExecutable;
    }

    public Consumer<ProcessLog> getProcessLogConsumer() {
        return this._processLogConsumer;
    }

    public ClassLoader getReactClassLoader() {
        return this._reactClassLoader;
    }

    public String getRuntimeClassPath() {
        return this._merge(this.getRuntimeClassPathHolders());
    }

    public PathHolder[] getRuntimeClassPathHolders() {
        return this._runtimeClassPathHolders;
    }

    private ProcessConfig(Builder builder) {
        this._arguments = builder._arguments;
        this._bootstrapClassPathHolders = this._toPathHolders(builder._bootstrapClassPath);
        this._environment = builder._environment;
        this._javaExecutable = builder._javaExecutable;
        this._processLogConsumer = builder._processLogConsumer;
        this._reactClassLoader = builder._reactClassLoader;
        this._runtimeClassPathHolders = this._toPathHolders(builder._runtimeClassPath);
    }

    private String _merge(PathHolder[] pathHolders) {
        StringBundler sb = new StringBundler(2 * pathHolders.length - 1);
        for (int i = 0; i < pathHolders.length; ++i) {
            sb.append((Object)pathHolders[i]);
            if (pathHolders.length - 1 == i) continue;
            sb.append(File.pathSeparator);
        }
        return sb.toString();
    }

    private PathHolder[] _toPathHolders(String classPath) {
        List classPathElements = StringUtil.split((String)classPath, (char)File.pathSeparatorChar);
        PathHolder[] classPathHolders = new PathHolder[classPathElements.size()];
        for (int i = 0; i < classPathElements.size(); ++i) {
            classPathHolders[i] = new PathHolder((String)classPathElements.get(i));
        }
        return classPathHolders;
    }

    public static class Builder {
        private List<String> _arguments = Collections.emptyList();
        private String _bootstrapClassPath = System.getProperty("java.class.path");
        private Map<String, String> _environment;
        private String _javaExecutable = "java";
        private Consumer<ProcessLog> _processLogConsumer = processLog -> {};
        private ClassLoader _reactClassLoader = ProcessConfig.class.getClassLoader();
        private String _runtimeClassPath = this._bootstrapClassPath;

        public ProcessConfig build() {
            return new ProcessConfig(this);
        }

        public Builder setArguments(List<String> arguments) {
            this._arguments = arguments;
            return this;
        }

        public Builder setBootstrapClassPath(String bootstrapClassPath) {
            this._bootstrapClassPath = bootstrapClassPath;
            return this;
        }

        public Builder setEnvironment(Map<String, String> environment) {
            this._environment = environment;
            return this;
        }

        public Builder setJavaExecutable(String javaExecutable) {
            this._javaExecutable = javaExecutable;
            return this;
        }

        public Builder setProcessLogConsumer(Consumer<ProcessLog> processLogConsumer) {
            this._processLogConsumer = processLogConsumer;
            return this;
        }

        public Builder setReactClassLoader(ClassLoader reactClassLoader) {
            this._reactClassLoader = reactClassLoader;
            return this;
        }

        public Builder setRuntimeClassPath(String runtimeClassPath) {
            this._runtimeClassPath = runtimeClassPath;
            return this;
        }
    }
}

