/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.util.Verbose;
import com.sforce.ws.wsdl.ParserUtil;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import javax.xml.namespace.QName;

public class Part
extends WsdlNode {
    private QName element;
    private String name;

    public String getName() {
        return this.name;
    }

    public QName getElement() throws ConnectionException {
        if (this.element == null) {
            throw new ConnectionException("Element not defined for part '" + this.name + "'");
        }
        return this.element;
    }

    public void read(WsdlParser parser) throws WsdlParseException {
        this.name = parser.getAttributeValue(null, "name");
        if (this.name == null) {
            throw new WsdlParseException("Unable to find name attribute in part");
        }
        String e = parser.getAttributeValue(null, "element");
        if (e == null) {
            Verbose.log("********* FIXME: document literal WSDL using part->type it must be part->element");
        } else {
            this.element = ParserUtil.toQName(e, parser);
        }
        int eventType = parser.getEventType();
        while (true) {
            if (eventType != 2 && eventType == 3) {
                String name = parser.getName();
                String namespace = parser.getNamespace();
                if ("part".equals(name) && "http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Part part = (Part)o;
        if (this.element != null ? !this.element.equals(part.element) : part.element != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(part.name) : part.name != null);
    }

    public int hashCode() {
        int result = this.element != null ? this.element.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Part{element=" + this.element + ", name='" + this.name + '\'' + '}';
    }
}

