/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.bind;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.bind.XMLizable;
import com.sforce.ws.bind.XmlObject;
import com.sforce.ws.parser.XmlInputStream;
import com.sforce.ws.parser.XmlOutputStream;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.PropertyUtils;

public class XmlObjectWrapper
extends XmlObject {
    private String defaultNamespace;
    private QName name;
    private QName xmlType;
    private XMLizable xmlizable;

    public XmlObjectWrapper(XMLizable xmlizable) {
        this.xmlizable = xmlizable;
    }

    @Override
    public XmlObject addField(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLizable asTyped() {
        return this.xmlizable;
    }

    @Override
    public XmlObject getChild(String name) {
        PropertyDescriptor descriptor = this.getPropertyDescriptor(name);
        if (descriptor != null) {
            try {
                Object value = descriptor.getReadMethod().invoke((Object)this.xmlizable, new Object[0]);
                if (value instanceof XmlObject) {
                    return (XmlObject)value;
                }
                if (value instanceof XMLizable) {
                    return new XmlObjectWrapper((XMLizable)value);
                }
                return new XmlObject(this.getQNameFor(descriptor.getName()), value);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Iterator<XmlObject> getChildren() {
        ArrayList<XmlObject> result = new ArrayList<XmlObject>();
        for (PropertyDescriptor descriptor : this.getPropertyDescriptors()) {
            this.addProperty(descriptor, result);
        }
        return result.iterator();
    }

    @Override
    public Iterator<XmlObject> getChildren(String name) {
        ArrayList<XmlObject> result = new ArrayList<XmlObject>();
        for (PropertyDescriptor descriptor : this.getPropertyDescriptors()) {
            if (!descriptor.getName().equals(name)) continue;
            this.addProperty(descriptor, result);
        }
        return result.iterator();
    }

    @Override
    public Object getField(String name) {
        PropertyDescriptor descriptor = this.getPropertyDescriptor(name);
        if (descriptor != null) {
            try {
                return descriptor.getReadMethod().invoke((Object)this.xmlizable, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public QName getXmlType() {
        return this.xmlType;
    }

    @Override
    public boolean hasChildren() {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(this.xmlizable);
        return descriptors.length != 0;
    }

    @Override
    public void load(XmlInputStream in, TypeMapper typeMapper) throws IOException, ConnectionException {
        this.name = new QName(in.getNamespace(), in.getName());
        this.xmlType = typeMapper.getXsiType(in);
        this.xmlizable.load(in, typeMapper);
    }

    @Override
    public boolean removeField(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefaultNamespace(String namespace) {
        this.defaultNamespace = namespace;
    }

    @Override
    public XmlObject setField(String name, Object value) {
        PropertyDescriptor descriptor = this.getPropertyDescriptor(name);
        if (descriptor != null) {
            try {
                descriptor.getWriteMethod().invoke((Object)this.xmlizable, value);
                return new XmlObjectWrapper((XMLizable)descriptor.getReadMethod().invoke((Object)this.xmlizable, new Object[0]));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setName(QName name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "XmlObjectWrapper{name=" + this.name + ", xmlizable=" + this.xmlizable + '}';
    }

    @Override
    public void write(QName element, XmlOutputStream out, TypeMapper typeMapper) throws IOException {
        this.xmlizable.write(element, out, typeMapper);
    }

    private void addProperty(PropertyDescriptor descriptor, ArrayList<XmlObject> result) {
        try {
            Object value = descriptor.getReadMethod().invoke((Object)this.xmlizable, new Object[0]);
            if (value instanceof XmlObject) {
                result.add((XmlObject)value);
            } else if (value instanceof XMLizable) {
                result.add(new XmlObjectWrapper((XMLizable)value));
            } else if (value instanceof Object[]) {
                for (Object subValue : (Object[])value) {
                    result.add(new XmlObject(this.getQNameFor(descriptor.getName()), subValue));
                }
            } else {
                result.add(new XmlObject(this.getQNameFor(descriptor.getName()), value));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private QName getQNameFor(String n) {
        String namespace = this.defaultNamespace == null ? "urn:sobject.partner.soap.sforce.com" : this.defaultNamespace;
        return this.name == null ? new QName(namespace, n) : new QName(this.name.getNamespaceURI(), n);
    }

    private PropertyDescriptor getPropertyDescriptor(String name) {
        for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors(this.xmlizable)) {
            if (!descriptor.getName().equals(name) || descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null) continue;
            return descriptor;
        }
        return null;
    }

    private List<PropertyDescriptor> getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors(this.xmlizable)) {
            if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }
}

