/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.ext;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.cometd.bayeux.BinaryData;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.common.Z85;

public class BinaryExtension
implements ClientSession.Extension {
    private final boolean decodeToByteBuffer;

    public BinaryExtension() {
        this(true);
    }

    public BinaryExtension(boolean decodeToByteBuffer) {
        this.decodeToByteBuffer = decodeToByteBuffer;
    }

    @Override
    public boolean rcv(ClientSession session, Message.Mutable message) {
        Map<String, Object> ext = message.getExt();
        if (ext != null && ext.remove("binary") != null) {
            Map<String, Object> data = message.getDataAsMap();
            BinaryData newData = new BinaryData((Map<? extends String, ?>)data);
            message.setData(newData);
            String encoded = (String)data.get("data");
            Object decoded = this.decodeToByteBuffer ? Z85.decoder.decodeByteBuffer(encoded) : (Object)Z85.decoder.decodeBytes(encoded);
            newData.put("data", decoded);
        }
        return true;
    }

    @Override
    public boolean send(ClientSession session, Message.Mutable message) {
        Object data = message.getData();
        if (data instanceof BinaryData) {
            String encoded;
            BinaryData binaryData = (BinaryData)data;
            Object binary = binaryData.get("data");
            if (binary instanceof byte[]) {
                encoded = Z85.encoder.encodeBytes(binaryData.asBytes());
            } else if (binary instanceof ByteBuffer) {
                encoded = Z85.encoder.encodeByteBuffer(binaryData.asByteBuffer());
            } else {
                throw new IllegalArgumentException("Cannot Z85 encode " + binary);
            }
            HashMap<String, Object> newData = new HashMap<String, Object>(binaryData);
            newData.put("data", encoded);
            message.setData(newData);
            Map<String, Object> ext = message.getExt(true);
            ext.put("binary", new HashMap(0));
        }
        return true;
    }
}

