/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.salesforce.client.partner;

import com.liferay.petra.salesforce.client.BaseSalesforceClientImpl;
import com.liferay.petra.salesforce.client.partner.SalesforcePartnerClient;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.GetDeletedResult;
import com.sforce.soap.partner.GetUpdatedResult;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class SalesforcePartnerClientImpl
extends BaseSalesforceClientImpl
implements SalesforcePartnerClient {
    @Override
    public List<SaveResult> create(SObject[] sObjects) throws ConnectionException {
        PartnerConnection partnerConnection = this.getPartnerConnection();
        SaveResult[] saveResults = partnerConnection.create(sObjects);
        return this._toList(saveResults);
    }

    @Override
    public List<DeleteResult> delete(String[] salesforceKeys) throws ConnectionException {
        PartnerConnection partnerConnection = this.getPartnerConnection();
        DeleteResult[] deleteResults = partnerConnection.delete(salesforceKeys);
        return this._toList(deleteResults);
    }

    @Override
    public DescribeGlobalResult describeGlobal(int retryCount) throws ConnectionException {
        try {
            PartnerConnection partnerConnection = this.getPartnerConnection();
            return partnerConnection.describeGlobal();
        }
        catch (ConnectionException connectionException) {
            return this.describeGlobal(this.getRetryCount(retryCount, connectionException));
        }
    }

    @Override
    public List<DescribeSObjectResult> describeSObjects(String[] typeNames, int retryCount) throws ConnectionException {
        try {
            PartnerConnection partnerConnection = this.getPartnerConnection();
            DescribeSObjectResult[] describeSObjectResults = partnerConnection.describeSObjects(typeNames);
            return this._toList(describeSObjectResults);
        }
        catch (ConnectionException connectionException) {
            return this.describeSObjects(typeNames, this.getRetryCount(retryCount, connectionException));
        }
    }

    @Override
    public GetDeletedResult getDeleted(String typeName, Calendar startCalendar, Calendar endCalendar, int retryCount) throws ConnectionException {
        try {
            PartnerConnection partnerConnection = this.getPartnerConnection();
            return partnerConnection.getDeleted(typeName, startCalendar, endCalendar);
        }
        catch (ConnectionException connectionException) {
            return this.getDeleted(typeName, startCalendar, endCalendar, this.getRetryCount(retryCount, connectionException));
        }
    }

    @Override
    public GetUpdatedResult getUpdated(String typeName, Calendar startCalendar, Calendar endCalendar, int retryCount) throws ConnectionException {
        try {
            PartnerConnection partnerConnection = this.getPartnerConnection();
            return partnerConnection.getUpdated(typeName, startCalendar, endCalendar);
        }
        catch (ConnectionException connectionException) {
            return this.getUpdated(typeName, startCalendar, endCalendar, this.getRetryCount(retryCount, connectionException));
        }
    }

    @Override
    public GetUserInfoResult getUserInfo() throws ConnectionException {
        PartnerConnection partnerConnection = this.getPartnerConnection();
        return partnerConnection.getUserInfo();
    }

    @Override
    public LoginResult login(String userName, String password, int retryCount) throws ConnectionException {
        try {
            PartnerConnection partnerConnection = this.getPartnerConnection();
            return partnerConnection.login(userName, password);
        }
        catch (ConnectionException connectionException) {
            return this.login(userName, password, this.getRetryCount(retryCount, connectionException));
        }
    }

    @Override
    public QueryResult query(String queryString, int retryCount) throws ConnectionException {
        try {
            PartnerConnection partnerConnection = this.getPartnerConnection();
            return partnerConnection.query(queryString);
        }
        catch (ConnectionException connectionException) {
            return this.query(queryString, this.getRetryCount(retryCount, connectionException));
        }
    }

    @Override
    public QueryResult queryAll(String queryString, int retryCount) throws ConnectionException {
        try {
            PartnerConnection partnerConnection = this.getPartnerConnection();
            return partnerConnection.queryAll(queryString);
        }
        catch (ConnectionException connectionException) {
            return this.queryAll(queryString, this.getRetryCount(retryCount, connectionException));
        }
    }

    @Override
    public QueryResult queryMore(String queryLocator, int retryCount) throws ConnectionException {
        try {
            PartnerConnection partnerConnection = this.getPartnerConnection();
            return partnerConnection.queryMore(queryLocator);
        }
        catch (ConnectionException connectionException) {
            return this.queryMore(queryLocator, this.getRetryCount(retryCount, connectionException));
        }
    }

    @Override
    public List<SObject> retrieve(String fieldNames, String typeName, String[] salesforceKeys, int retryCount) throws ConnectionException {
        try {
            PartnerConnection partnerConnection = this.getPartnerConnection();
            SObject[] sObjects = partnerConnection.retrieve(fieldNames, typeName, salesforceKeys);
            return this._toList(sObjects);
        }
        catch (ConnectionException connectionException) {
            return this.retrieve(fieldNames, typeName, salesforceKeys, this.getRetryCount(retryCount, connectionException));
        }
    }

    @Override
    public List<SaveResult> update(SObject[] sObjects) throws ConnectionException {
        PartnerConnection partnerConnection = this.getPartnerConnection();
        SaveResult[] saveResults = partnerConnection.update(sObjects);
        return this._toList(saveResults);
    }

    @Override
    public List<UpsertResult> upsert(String salesforceExternalKeyFieldName, SObject[] sObjects) throws ConnectionException {
        PartnerConnection partnerConnection = this.getPartnerConnection();
        UpsertResult[] upsertResults = partnerConnection.upsert(salesforceExternalKeyFieldName, sObjects);
        return this._toList(upsertResults);
    }

    private <E> List<E> _toList(E[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }
}

