/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.phone.apio.internal.architect.router;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.ReusableNestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.phone.apio.architect.identifier.PhoneIdentifier;
import com.liferay.portal.apio.identifier.ClassNameClassPK;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.PhoneService;
import com.liferay.portal.kernel.service.UserService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ReusableNestedCollectionRouter.class})
public class PhoneReusableNestedCollectionRouter
implements ReusableNestedCollectionRouter<Phone, Long, PhoneIdentifier, ClassNameClassPK> {
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private PhoneService _phoneService;
    @Reference
    private UserService _userService;

    public NestedCollectionRoutes<Phone, Long, ClassNameClassPK> collectionRoutes(NestedCollectionRoutes.Builder<Phone, Long, ClassNameClassPK> builder) {
        return builder.addGetter(this::_getPageItems).build();
    }

    private PageItems<Phone> _getPageItems(Pagination pagination, ClassNameClassPK classNameClassPK) throws PortalException {
        List<Phone> phones = this._getPhones(classNameClassPK);
        int count = phones.size();
        int endPosition = Math.min(count, pagination.getEndPosition());
        return new PageItems(phones.subList(pagination.getStartPosition(), endPosition), count);
    }

    private List<Phone> _getPhones(ClassNameClassPK classNameClassPK) throws PortalException {
        String className = classNameClassPK.getClassName();
        if (className.equals(Organization.class.getName())) {
            Organization organization = this._organizationService.getOrganization(classNameClassPK.getClassPK());
            return this._phoneService.getPhones(organization.getModelClassName(), organization.getOrganizationId());
        }
        User user = this._userService.getUserById(classNameClassPK.getClassPK());
        return this._phoneService.getPhones(Contact.class.getName(), user.getContactId());
    }
}

