/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal.dao.orm;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.cache.internal.dao.orm.EmptyResult;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.servlet.filters.threadlocal.ThreadLocalFilterThreadLocal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CacheRegistryItem.class, FinderCache.class, FinderCacheImpl.class})
public class FinderCacheImpl
implements CacheRegistryItem,
FinderCache,
PortalCacheManagerListener {
    private static final String _GROUP_KEY_PREFIX = FinderCache.class.getName() + ".";
    private ServiceTrackerMap<String, ArgumentsResolver> _argumentsResolverServiceTrackerMap;
    private ServiceTrackerMap<String, List<FinderPath>> _finderPathServiceTrackerMap;
    private ThreadLocal<LRUMap> _localCache;
    @Reference
    private MultiVMPool _multiVMPool;
    private final ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();
    @Reference
    private Props _props;
    private boolean _valueObjectFinderCacheEnabled;
    private int _valueObjectFinderCacheListThreshold;

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(String className) {
        this.clearLocalCache();
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(className);
        portalCache.removeAll();
    }

    public void clearCacheByEntityCache(Class<?> clazz) {
        String cacheName = clazz.getName();
        this.clearCache(cacheName);
        this.clearCache(this._getCacheNameWithPagination(cacheName));
        this.clearCache(this._getCacheNameWithoutPagination(cacheName));
    }

    public void clearLocalCache() {
        if (this._isLocalCacheEnabled()) {
            this._localCache.remove();
        }
    }

    public void dispose() {
        this._portalCaches.clear();
    }

    public String getRegistryName() {
        return FinderCache.class.getName();
    }

    public Object getResult(FinderPath finderPath, Object[] args, BasePersistenceImpl<? extends BaseModel<?>> basePersistenceImpl) {
        PortalCache<Serializable, Serializable> portalCache;
        if (!this._valueObjectFinderCacheEnabled || !CacheRegistryUtil.isActive()) {
            return null;
        }
        Serializable cacheKey = finderPath.encodeCacheKey(args);
        Serializable cacheValue = null;
        Map localCache = null;
        LocalCacheKey localCacheKey = null;
        if (this._isLocalCacheEnabled()) {
            localCache = (Map)this._localCache.get();
            localCacheKey = new LocalCacheKey(finderPath.getCacheName(), cacheKey);
            cacheValue = (Serializable)localCache.get(localCacheKey);
        }
        if (cacheValue == null && (cacheValue = (Serializable)(portalCache = this._getPortalCache(finderPath.getCacheName())).get(cacheKey)) != null && localCache != null) {
            localCache.put(localCacheKey, cacheValue);
        }
        if (cacheValue == null) {
            return null;
        }
        if (cacheValue instanceof EmptyResult) {
            EmptyResult emptyResult = (EmptyResult)cacheValue;
            if (emptyResult.matches(args)) {
                return Collections.emptyList();
            }
            return null;
        }
        if (cacheValue instanceof List) {
            List primaryKeys = (List)((Object)cacheValue);
            HashSet primaryKeysSet = new HashSet(primaryKeys);
            Map map = basePersistenceImpl.fetchByPrimaryKeys(primaryKeysSet);
            if (map.size() < primaryKeysSet.size()) {
                return null;
            }
            ArrayList list = new ArrayList(primaryKeys.size());
            for (Serializable curPrimaryKey : primaryKeys) {
                list.add(map.get(curPrimaryKey));
            }
            return Collections.unmodifiableList(list);
        }
        if (finderPath.isBaseModelResult()) {
            return basePersistenceImpl.fetchByPrimaryKey(cacheValue);
        }
        return cacheValue;
    }

    public void init() {
    }

    public void invalidate() {
        this.clearCache();
    }

    public void notifyPortalCacheAdded(String portalCacheName) {
    }

    public void notifyPortalCacheRemoved(String portalCacheName) {
        if (portalCacheName.startsWith(_GROUP_KEY_PREFIX)) {
            this._portalCaches.remove(portalCacheName.substring(_GROUP_KEY_PREFIX.length()));
        }
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result) {
        this.putResult(finderPath, args, result, true);
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result, boolean quiet) {
        if (!this._valueObjectFinderCacheEnabled || !CacheRegistryUtil.isActive() || result == null) {
            return;
        }
        ArrayList<Serializable> cacheValue = (ArrayList<Serializable>)result;
        if (result instanceof BaseModel) {
            BaseModel model = (BaseModel)result;
            cacheValue = model.getPrimaryKeyObj();
        } else if (result instanceof List) {
            List baseModels = (List)result;
            if (baseModels.isEmpty()) {
                cacheValue = new EmptyResult(args);
            } else {
                if (baseModels.size() > this._valueObjectFinderCacheListThreshold && this._valueObjectFinderCacheListThreshold > 0) {
                    this._removeResult(finderPath, args);
                    return;
                }
                ArrayList<Serializable> primaryKeys = new ArrayList<Serializable>(baseModels.size());
                for (BaseModel baseModel : baseModels) {
                    primaryKeys.add(baseModel.getPrimaryKeyObj());
                }
                cacheValue = primaryKeys;
            }
        }
        Serializable cacheKey = finderPath.encodeCacheKey(args);
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            localCache.put(new LocalCacheKey(finderPath.getCacheName(), cacheKey), cacheValue);
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName());
        if (quiet) {
            PortalCacheHelperUtil.putWithoutReplicator(portalCache, (Serializable)cacheKey, (Object)cacheValue);
        } else {
            portalCache.put(cacheKey, (Object)cacheValue);
        }
    }

    public void removeByEntityCache(Class<?> clazz, BaseModel<?> baseModel) {
        String cacheName = clazz.getName();
        this.clearCache(this._getCacheNameWithPagination(cacheName));
        this.clearCache(this._getCacheNameWithoutPagination(cacheName));
        for (FinderPath finderPath : this._getFinderPaths(cacheName)) {
            this.removeResult(finderPath, this._getArguments(finderPath, baseModel, false, false));
            this.removeResult(finderPath, this._getArguments(finderPath, baseModel, true, true));
        }
    }

    public void removeCache(String className) {
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removePortalCache(groupKey);
    }

    public void removeCacheByEntityCache(String cacheName) {
        this.removeCache(cacheName);
        this.removeCache(this._getCacheNameWithPagination(cacheName));
        this.removeCache(this._getCacheNameWithoutPagination(cacheName));
    }

    public void removeResult(FinderPath finderPath, Object[] args) {
        if (!this._valueObjectFinderCacheEnabled || !CacheRegistryUtil.isActive()) {
            return;
        }
        this._removeResult(finderPath, args);
    }

    public void updateByEntityCache(Class<?> clazz, BaseModel<?> baseModel) {
        if (!this._valueObjectFinderCacheEnabled) {
            return;
        }
        String cacheName = clazz.getName();
        this.clearCache(this._getCacheNameWithPagination(cacheName));
        for (FinderPath finderPath : this._getFinderPaths(this._getCacheNameWithoutPagination(cacheName))) {
            if (baseModel.isNew()) {
                this._removeResult(finderPath, this._getArguments(finderPath, baseModel, false, false));
                continue;
            }
            this._removeResult(finderPath, this._getArguments(finderPath, baseModel, true, false));
            this._removeResult(finderPath, this._getArguments(finderPath, baseModel, true, true));
        }
        for (FinderPath finderPath : this._getFinderPaths(cacheName)) {
            this._removeResult(finderPath, this._getArguments(finderPath, baseModel, true, true));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        int localCacheMaxSize;
        this._valueObjectFinderCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.finder.cache.enabled"));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)this._props.get("value.object.finder.cache.list.threshold"));
        if (this._valueObjectFinderCacheListThreshold == 0) {
            this._valueObjectFinderCacheEnabled = false;
        }
        this._localCache = (localCacheMaxSize = GetterUtil.getInteger((String)this._props.get("value.object.finder.thread.local.cache.max.size"))) > 0 ? new CentralizedThreadLocal(FinderCacheImpl.class + "._localCache", () -> new LRUMap(localCacheMaxSize)) : null;
        PortalCacheManager portalCacheManager = this._multiVMPool.getPortalCacheManager();
        portalCacheManager.registerPortalCacheManagerListener((PortalCacheManagerListener)this);
        this._finderPathServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, FinderPath.class, (String)"cache.name");
        this._argumentsResolverServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ArgumentsResolver.class, (String)"model.class.name");
    }

    @Deactivate
    protected void deactivate() {
        this._finderPathServiceTrackerMap.close();
        this._argumentsResolverServiceTrackerMap.close();
    }

    private Object[] _getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
        ArgumentsResolver argumentsResolver = (ArgumentsResolver)this._argumentsResolverServiceTrackerMap.getService((Object)baseModel.getModelClassName());
        return argumentsResolver.getArguments(finderPath, baseModel, checkColumn, original);
    }

    private String _getCacheNameWithoutPagination(String cacheName) {
        return cacheName.concat(".List2");
    }

    private String _getCacheNameWithPagination(String cacheName) {
        return cacheName.concat(".List1");
    }

    private List<FinderPath> _getFinderPaths(String cacheName) {
        List finderPaths = (List)this._finderPathServiceTrackerMap.getService((Object)cacheName);
        if (finderPaths == null) {
            return Collections.emptyList();
        }
        return finderPaths;
    }

    private PortalCache<Serializable, Serializable> _getPortalCache(String className) {
        PortalCache portalCache = (PortalCache)this._portalCaches.get(className);
        if (portalCache != null) {
            return portalCache;
        }
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        portalCache = this._multiVMPool.getPortalCache(groupKey);
        PortalCache<Serializable, Serializable> previousPortalCache = this._portalCaches.putIfAbsent(className, (PortalCache<Serializable, Serializable>)portalCache);
        if (previousPortalCache != null) {
            return previousPortalCache;
        }
        return portalCache;
    }

    private boolean _isLocalCacheEnabled() {
        if (this._localCache == null) {
            return false;
        }
        return ThreadLocalFilterThreadLocal.isFilterInvoked();
    }

    private void _removeResult(FinderPath finderPath, Object[] args) {
        if (args == null) {
            return;
        }
        Serializable cacheKey = finderPath.encodeCacheKey(args);
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            localCache.remove(new LocalCacheKey(finderPath.getCacheName(), cacheKey));
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName());
        portalCache.remove(cacheKey);
    }

    private static class LocalCacheKey {
        private final Serializable _cacheKey;
        private final String _className;

        public boolean equals(Object object) {
            LocalCacheKey localCacheKey = (LocalCacheKey)object;
            return this._className.equals(localCacheKey._className) && this._cacheKey.equals(localCacheKey._cacheKey);
        }

        public int hashCode() {
            return HashUtil.hash((int)this._className.hashCode(), (int)this._cacheKey.hashCode());
        }

        private LocalCacheKey(String className, Serializable cacheKey) {
            this._className = className;
            this._cacheKey = cacheKey;
        }
    }
}

