/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal.dao.orm;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.cache.internal.dao.orm.FinderCacheImpl;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LRUMap;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.servlet.filters.threadlocal.ThreadLocalFilterThreadLocal;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CacheRegistryItem.class, EntityCache.class})
public class EntityCacheImpl
implements CacheRegistryItem,
EntityCache,
PortalCacheManagerListener {
    private static final String _GROUP_KEY_PREFIX = EntityCache.class.getName() + ".";
    private static volatile FinderCacheImpl _finderCacheImpl;
    private boolean _dbPartitionEnabled;
    private ThreadLocal<LRUMap<Serializable, Serializable>> _localCache;
    @Reference
    private MultiVMPool _multiVMPool;
    private final ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();
    @Reference
    private Props _props;
    private boolean _valueObjectEntityCacheEnabled;
    private boolean _valueObjectMVCCEntityCacheEnabled;

    public void clearCache() {
        this._notifyFinderCache(null, null, false);
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(Class<?> clazz) {
        this._notifyFinderCache(clazz.getName(), null, false);
        this.clearLocalCache();
        PortalCache<Serializable, Serializable> portalCache = this.getPortalCache(clazz);
        portalCache.removeAll();
    }

    public void clearLocalCache() {
        if (this._isLocalCacheEnabled()) {
            this._localCache.remove();
        }
    }

    public void dispose() {
        this._notifyFinderCache(null, null, true);
        this._portalCaches.clear();
    }

    public Serializable getLocalCacheResult(Class<?> clazz, Serializable primaryKey) {
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            LocalCacheKey localCacheKey = new LocalCacheKey(clazz.getName(), primaryKey);
            return (Serializable)localCache.get(localCacheKey);
        }
        return null;
    }

    public PortalCache<Serializable, Serializable> getPortalCache(Class<?> clazz) {
        PortalCache<Serializable, Serializable> previousPortalCache;
        String className = clazz.getName();
        PortalCache portalCache = (PortalCache)this._portalCaches.get(className);
        if (portalCache != null) {
            return portalCache;
        }
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        boolean mvcc = false;
        if (this._valueObjectMVCCEntityCacheEnabled && MVCCModel.class.isAssignableFrom(clazz)) {
            mvcc = true;
        }
        boolean sharded = false;
        if (this._dbPartitionEnabled && ShardedModel.class.isAssignableFrom(clazz)) {
            sharded = true;
        }
        if ((previousPortalCache = this._portalCaches.putIfAbsent(className, (PortalCache<Serializable, Serializable>)(portalCache = this._multiVMPool.getPortalCache(groupKey, mvcc, sharded)))) != null) {
            return previousPortalCache;
        }
        return portalCache;
    }

    public String getRegistryName() {
        return EntityCache.class.getName();
    }

    public Serializable getResult(Class<?> clazz, Serializable primaryKey) {
        if (!this._valueObjectEntityCacheEnabled || !CacheRegistryUtil.isActive()) {
            return null;
        }
        Object result = null;
        Map localCache = null;
        LocalCacheKey localCacheKey = null;
        if (this._isLocalCacheEnabled()) {
            localCache = (Map)this._localCache.get();
            localCacheKey = new LocalCacheKey(clazz.getName(), primaryKey);
            result = (Serializable)localCache.get(localCacheKey);
        }
        if (result == null) {
            PortalCache<Serializable, Serializable> portalCache = this.getPortalCache(clazz);
            result = (Serializable)portalCache.get(primaryKey);
            if (result == null) {
                result = "";
            }
            if (localCache != null) {
                localCache.put(localCacheKey, result);
            }
        }
        return this._toEntityModel((Serializable)result);
    }

    public void init() {
    }

    public void invalidate() {
        this.clearCache();
    }

    public void notifyPortalCacheAdded(String portalCacheName) {
    }

    public void notifyPortalCacheRemoved(String portalCacheName) {
        String cacheName = portalCacheName;
        if (portalCacheName.startsWith(_GROUP_KEY_PREFIX)) {
            cacheName = portalCacheName.substring(_GROUP_KEY_PREFIX.length());
        }
        this._notifyFinderCache(cacheName, null, true);
        this._portalCaches.remove(cacheName);
    }

    public void putResult(Class<?> clazz, BaseModel<?> baseModel, boolean quiet, boolean updateFinderCache) {
        this._putResult(clazz, baseModel.getPrimaryKeyObj(), baseModel, quiet, updateFinderCache);
    }

    public void putResult(Class<?> clazz, Serializable primaryKey, Serializable result) {
        this._putResult(clazz, primaryKey, (BaseModel)result, true, false);
    }

    public void removeCache(String className) {
        this._notifyFinderCache(className, null, true);
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removePortalCache(groupKey);
    }

    public void removeResult(Class<?> clazz, BaseModel<?> baseModel) {
        this._removeResult(clazz, baseModel.getPrimaryKeyObj(), baseModel);
    }

    public void removeResult(Class<?> clazz, Serializable primaryKey) {
        this._removeResult(clazz, primaryKey, null);
    }

    @Activate
    protected void activate() {
        this._dbPartitionEnabled = GetterUtil.getBoolean((String)this._props.get("database.partition.enabled"));
        this._valueObjectEntityCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.entity.cache.enabled"));
        this._valueObjectMVCCEntityCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.mvcc.entity.cache.enabled"));
        int localCacheMaxSize = GetterUtil.getInteger((String)this._props.get("value.object.entity.thread.local.cache.max.size"));
        this._localCache = !this._dbPartitionEnabled && localCacheMaxSize > 0 ? new CentralizedThreadLocal(EntityCacheImpl.class + "._localCache", () -> new LRUMap(localCacheMaxSize)) : null;
        PortalCacheManager portalCacheManager = this._multiVMPool.getPortalCacheManager();
        portalCacheManager.registerPortalCacheManagerListener((PortalCacheManagerListener)this);
    }

    @Reference(unbind="-")
    protected void setFinderCacheImpl(FinderCacheImpl finderCacheImpl) {
        _finderCacheImpl = finderCacheImpl;
    }

    private boolean _isLocalCacheEnabled() {
        if (this._localCache == null) {
            return false;
        }
        return ThreadLocalFilterThreadLocal.isFilterInvoked();
    }

    private void _notifyFinderCache(String className, BaseModel<?> baseModel, Boolean removePortalCache) {
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)CompanyThreadLocal.getCompanyId());){
            FinderCacheImpl finderCacheImpl = _finderCacheImpl;
            if (finderCacheImpl == null) {
                return;
            }
            if (removePortalCache == null) {
                finderCacheImpl.updateByEntityCache(className, baseModel);
            } else if (baseModel != null) {
                finderCacheImpl.removeByEntityCache(className, baseModel);
            } else if (removePortalCache.booleanValue()) {
                if (className == null) {
                    finderCacheImpl.dispose();
                } else {
                    finderCacheImpl.removeCacheByEntityCache(className);
                }
            } else if (className == null) {
                finderCacheImpl.clearCache();
            } else {
                finderCacheImpl.clearByEntityCache(className);
            }
        }
    }

    private void _putResult(Class<?> clazz, Serializable primaryKey, BaseModel<?> baseModel, boolean quiet, boolean updateFinderCache) {
        if (!this._valueObjectEntityCacheEnabled || !CacheRegistryUtil.isActive() || baseModel == null) {
            return;
        }
        if (!quiet && updateFinderCache) {
            this._notifyFinderCache(clazz.getName(), baseModel, null);
        }
        CacheModel result = baseModel.toCacheModel();
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            LocalCacheKey localCacheKey = new LocalCacheKey(clazz.getName(), primaryKey);
            localCache.put(localCacheKey, result);
        }
        PortalCache<Serializable, Serializable> portalCache = this.getPortalCache(clazz);
        if (quiet) {
            PortalCacheHelperUtil.putWithoutReplicator(portalCache, (Serializable)primaryKey, (Object)result);
        } else {
            portalCache.put(primaryKey, (Object)result);
        }
    }

    private void _removeResult(Class<?> clazz, Serializable primaryKey, BaseModel<?> baseModel) {
        if (!this._valueObjectEntityCacheEnabled || !CacheRegistryUtil.isActive()) {
            return;
        }
        if (baseModel != null) {
            this._notifyFinderCache(clazz.getName(), baseModel, false);
        }
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            LocalCacheKey localCacheKey = new LocalCacheKey(clazz.getName(), primaryKey);
            localCache.remove(localCacheKey);
        }
        PortalCache<Serializable, Serializable> portalCache = this.getPortalCache(clazz);
        portalCache.remove(primaryKey);
    }

    private Serializable _toEntityModel(Serializable result) {
        if (result == "") {
            return null;
        }
        CacheModel cacheModel = (CacheModel)result;
        BaseModel entityModel = (BaseModel)cacheModel.toEntityModel();
        entityModel.setCachedModel(true);
        return entityModel;
    }

    private static class LocalCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _className;
        private final Serializable _primaryKey;

        public LocalCacheKey(String className, Serializable primaryKey) {
            this._className = className;
            this._primaryKey = primaryKey;
        }

        public boolean equals(Object object) {
            LocalCacheKey localCacheKey = (LocalCacheKey)object;
            return localCacheKey._className.equals(this._className) && localCacheKey._primaryKey.equals(this._primaryKey);
        }

        public int hashCode() {
            return this._className.hashCode() * 11 + this._primaryKey.hashCode();
        }
    }
}

