/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.test.util;

import com.liferay.portal.cache.BasePortalCacheManager;
import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.cache.test.util.TestPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TestPortalCacheManager<K extends Serializable, V>
extends BasePortalCacheManager<K, V> {
    private ConcurrentMap<String, TestPortalCache<K, V>> _testPortalCaches;

    public static <K extends Serializable, V> TestPortalCacheManager<K, V> createTestPortalCacheManager(String portalCacheManagerName) {
        TestPortalCacheManager<K, V> testPortalCacheManager = new TestPortalCacheManager<K, V>();
        testPortalCacheManager.setPortalCacheManagerName(portalCacheManagerName);
        testPortalCacheManager.initialize();
        return testPortalCacheManager;
    }

    @Deprecated
    public void reconfigurePortalCaches(URL configurationURL) {
        throw new UnsupportedOperationException();
    }

    public void reconfigurePortalCaches(URL configurationURL, ClassLoader classLoader) {
        throw new UnsupportedOperationException();
    }

    protected PortalCache<K, V> createPortalCache(PortalCacheConfiguration portalCacheConfiguration) {
        String portalCacheName = portalCacheConfiguration.getPortalCacheName();
        TestPortalCache portalCache = (TestPortalCache)((Object)this._testPortalCaches.get(portalCacheName));
        if (portalCache != null) {
            return portalCache;
        }
        portalCache = new TestPortalCache(this, portalCacheName);
        TestPortalCache previousPortalCache = this._testPortalCaches.putIfAbsent(portalCacheName, portalCache);
        if (previousPortalCache == null) {
            this.aggregatedPortalCacheManagerListener.notifyPortalCacheAdded(portalCacheName);
        } else {
            portalCache = previousPortalCache;
        }
        return portalCache;
    }

    protected void doClearAll() {
        for (TestPortalCache testPortalCache : this._testPortalCaches.values()) {
            testPortalCache.removeAll();
        }
    }

    protected void doDestroy() {
        for (TestPortalCache testPortalCache : this._testPortalCaches.values()) {
            testPortalCache.removeAll();
        }
        this.aggregatedPortalCacheManagerListener.dispose();
    }

    protected void doRemovePortalCache(String portalCacheName) {
        TestPortalCache testPortalCache = (TestPortalCache)((Object)this._testPortalCaches.remove(portalCacheName));
        testPortalCache.removeAll();
        this.aggregatedPortalCacheManagerListener.notifyPortalCacheRemoved(portalCacheName);
    }

    protected PortalCacheManagerConfiguration getPortalCacheManagerConfiguration() {
        return new PortalCacheManagerConfiguration(null, new PortalCacheConfiguration("default", null, null), null);
    }

    protected void initPortalCacheManager() {
        this._testPortalCaches = new ConcurrentHashMap<String, TestPortalCache<K, V>>();
        this.aggregatedPortalCacheManagerListener.init();
    }

    protected void removeConfigurableEhcachePortalCacheListeners(PortalCache<K, V> portalCache) {
    }
}

