/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.k8s.agent.internal.model.listener;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.k8s.agent.PortalK8sConfigMapModifier;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.k8s.agent.configuration.PortalK8sAgentConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={ModelListener.class})
public class VirtualHostModelListener
extends BaseModelListener<VirtualHost> {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private PortalK8sConfigMapModifier _portalK8sConfigMapModifier;
    @Reference
    private VirtualHostLocalService _virtualHostLocalService;

    public void onAfterCreate(VirtualHost virtualHost) {
        Company company = this._companyLocalService.fetchCompanyById(virtualHost.getCompanyId());
        this._modifyConfigMap(company);
    }

    public void onAfterRemove(VirtualHost virtualHost) throws ModelListenerException {
        Company company = this._companyLocalService.fetchCompanyById(virtualHost.getCompanyId());
        if (Objects.equals(company.getWebId(), PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            return;
        }
        this._portalK8sConfigMapModifier.modifyConfigMap(configMapModel -> {
            Map data = configMapModel.data();
            data.clear();
            Map labels = configMapModel.labels();
            labels.clear();
        }, this._getConfigMapName(company));
    }

    public void onAfterUpdate(VirtualHost originalVirtualHost, VirtualHost virtualHost) throws ModelListenerException {
        Company company = this._companyLocalService.fetchCompanyById(virtualHost.getCompanyId());
        this._modifyConfigMap(company);
    }

    @Activate
    protected void activate() {
        this._companyLocalService.forEachCompany(this::_modifyConfigMap);
    }

    private String _getConfigMapName(Company company) {
        return company.getWebId() + "-lxc-dxp-metadata";
    }

    private String _getWebServerProtocol() {
        String webServerProtocol = PropsValues.WEB_SERVER_PROTOCOL;
        if (Validator.isNull((String)webServerProtocol)) {
            return "http";
        }
        return webServerProtocol;
    }

    private void _modifyConfigMap(Company company) {
        ArrayList<String> virtualHostNames = new ArrayList<String>();
        for (VirtualHost virtualHost : this._virtualHostLocalService.getVirtualHosts(company.getCompanyId())) {
            virtualHostNames.add(virtualHost.getHostname());
        }
        this._portalK8sConfigMapModifier.modifyConfigMap(configMapModel -> {
            Map data = configMapModel.data();
            data.put("com.liferay.lxc.dxp.domains", StringUtil.merge((Collection)virtualHostNames, (String)"\n"));
            data.put("com.liferay.lxc.dxp.mainDomain", company.getVirtualHostname());
            data.put("com.liferay.lxc.dxp.server.protocol", this._getWebServerProtocol());
            Map labels = configMapModel.labels();
            labels.put("dxp.lxc.liferay.com/virtualInstanceId", company.getWebId());
            labels.put("lxc.liferay.com/metadataType", "dxp");
        }, this._getConfigMapName(company));
    }
}

