/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.license.deployer.internal;

import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class LPKGLicensedBundleTrackerCustomizer
implements BundleTrackerCustomizer<Bundle> {
    private static final Log _log = LogFactoryUtil.getLog(LPKGLicensedBundleTrackerCustomizer.class);
    private final FileInstaller _licenseInstaller;

    public LPKGLicensedBundleTrackerCustomizer(FileInstaller licenseInstaller) {
        this._licenseInstaller = licenseInstaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        URL url = bundle.getEntry("liferay-marketplace.properties");
        if (url == null) {
            return null;
        }
        File file = new File(bundle.getLocation());
        if (!file.exists()) {
            return null;
        }
        boolean hasLicense = false;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String zipEntryName = zipEntry.getName();
                if (!zipEntryName.endsWith(".xml")) continue;
                Path tempFilePath = Files.createTempFile(null, ".xml", new FileAttribute[0]);
                try {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Throwable throwable = null;
                    try {
                        Files.copy(inputStream, tempFilePath, StandardCopyOption.REPLACE_EXISTING);
                        File tempFile = tempFilePath.toFile();
                        if (!this._licenseInstaller.canTransformURL(tempFile)) continue;
                        this._licenseInstaller.transformURL(tempFile);
                        hasLicense = true;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                finally {
                    Files.delete(tempFilePath);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to register license", (Throwable)exception);
            return null;
        }
        if (hasLicense) {
            return bundle;
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle trackedBundle) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle trackedBundle) {
    }
}

