/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.license.deployer.internal;

import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.license.deployer.internal.LPKGLicensedBundleTrackerCustomizer;
import com.liferay.portal.license.deployer.internal.installer.LicenseInstaller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={})
public class LicenseDeployerActivator {
    private ServiceRegistration<?> _artifactListenerServiceRegistration;
    private BundleTracker<Bundle> _lpkgLicensedBundleTracker;

    @Activate
    protected void activate(BundleContext bundleContext) {
        LicenseInstaller fileInstaller = new LicenseInstaller();
        this._artifactListenerServiceRegistration = this.registerArtifactListener(bundleContext, fileInstaller);
        this._lpkgLicensedBundleTracker = new BundleTracker(bundleContext, -2, (BundleTrackerCustomizer)new LPKGLicensedBundleTrackerCustomizer(fileInstaller));
        this._lpkgLicensedBundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._artifactListenerServiceRegistration.unregister();
    }

    protected ServiceRegistration<?> registerArtifactListener(BundleContext bundleContext, FileInstaller fileInstaller) {
        return bundleContext.registerService(FileInstaller.class, (Object)fileInstaller, null);
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

