/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.portal.kernel.executor.PortalExecutorManager;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.messaging.internal.DestinationPrototype;
import com.liferay.portal.messaging.internal.ParallelDestinationPrototype;
import com.liferay.portal.messaging.internal.SerialDestinationPrototype;
import com.liferay.portal.messaging.internal.SynchronousDestinationPrototype;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DestinationFactory.class})
public class DefaultDestinationFactory
implements DestinationFactory {
    private final ConcurrentMap<String, DestinationPrototype> _destinationPrototypes = new ConcurrentHashMap<String, DestinationPrototype>();

    public Destination createDestination(DestinationConfiguration destinationConfiguration) {
        String type = destinationConfiguration.getDestinationType();
        DestinationPrototype destinationPrototype = (DestinationPrototype)this._destinationPrototypes.get(type);
        if (destinationPrototype == null) {
            throw new IllegalArgumentException("No destination prototype configured for " + type);
        }
        return destinationPrototype.createDestination(destinationConfiguration);
    }

    public Collection<String> getDestinationTypes() {
        return Collections.unmodifiableCollection(this._destinationPrototypes.keySet());
    }

    @Activate
    protected void activate() {
        this._destinationPrototypes.put("parallel", new ParallelDestinationPrototype());
        this._destinationPrototypes.put("serial", new SerialDestinationPrototype());
        this._destinationPrototypes.put("synchronous", new SynchronousDestinationPrototype());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDestinationPrototype(DestinationPrototype destinationPrototype, Map<String, Object> properties) {
        this._destinationPrototypes.put(MapUtil.getString(properties, (String)"destination.type"), destinationPrototype);
    }

    @Deactivate
    protected void deactivate() {
        this._destinationPrototypes.clear();
    }

    protected void removeDestinationPrototype(DestinationPrototype destinationPrototype, Map<String, Object> properties) {
        this._destinationPrototypes.remove(MapUtil.getString(properties, (String)"destination.type"), destinationPrototype);
    }

    @Reference(unbind="-")
    protected void setPortalExecutorManager(PortalExecutorManager portalExecutorManager) {
    }
}

