/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;

public class MessageBusThreadLocalUtil {
    public static void populateMessageFromThreadLocals(Message message) {
        if (!message.contains("companyId")) {
            message.put("companyId", (Object)CompanyThreadLocal.getCompanyId());
        }
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            message.put("clusterInvoke", (Object)Boolean.FALSE);
        }
        if (!message.contains("defaultLocale")) {
            message.put("defaultLocale", (Object)LocaleThreadLocal.getDefaultLocale());
        }
        if (!message.contains("groupId")) {
            message.put("groupId", (Object)GroupThreadLocal.getGroupId());
        }
        if (!message.contains("permissionChecker")) {
            message.put("permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
        }
        if (!message.contains("principalName")) {
            message.put("principalName", (Object)PrincipalThreadLocal.getName());
        }
        if (!message.contains("principalPassword")) {
            message.put("principalPassword", (Object)PrincipalThreadLocal.getPassword());
        }
        if (!message.contains("siteDefaultLocale")) {
            message.put("siteDefaultLocale", (Object)LocaleThreadLocal.getSiteDefaultLocale());
        }
        if (!message.contains("themeDisplayLocale")) {
            message.put("themeDisplayLocale", (Object)LocaleThreadLocal.getThemeDisplayLocale());
        }
    }

    public static void populateThreadLocalsFromMessage(Message message, PermissionCheckerFactory permissionCheckerFactory, UserLocalService userLocalService) {
        Locale themeDisplayLocale;
        Locale siteDefaultLocale;
        String principalPassword;
        long groupId;
        Locale defaultLocale;
        Boolean clusterInvoke;
        long companyId = message.getLong("companyId");
        if (companyId > 0L) {
            CompanyThreadLocal.setCompanyId((Long)companyId);
        }
        if ((clusterInvoke = (Boolean)message.get("clusterInvoke")) != null) {
            ClusterInvokeThreadLocal.setEnabled((boolean)clusterInvoke);
        }
        if ((defaultLocale = (Locale)message.get("defaultLocale")) != null) {
            LocaleThreadLocal.setDefaultLocale((Locale)defaultLocale);
        }
        if ((groupId = message.getLong("groupId")) > 0L) {
            GroupThreadLocal.setGroupId((Long)groupId);
        }
        PermissionChecker permissionChecker = (PermissionChecker)message.get("permissionChecker");
        String principalName = message.getString("principalName");
        if (Validator.isNotNull((String)principalName)) {
            PrincipalThreadLocal.setName((String)principalName);
        }
        if (permissionChecker == null && Validator.isNotNull((String)principalName)) {
            try {
                User user = userLocalService.fetchUser(PrincipalThreadLocal.getUserId());
                permissionChecker = permissionCheckerFactory.create(user);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (permissionChecker != null) {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        if (Validator.isNotNull((String)(principalPassword = message.getString("principalPassword")))) {
            PrincipalThreadLocal.setPassword((String)principalPassword);
        }
        if ((siteDefaultLocale = (Locale)message.get("siteDefaultLocale")) != null) {
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
        if ((themeDisplayLocale = (Locale)message.get("themeDisplayLocale")) != null) {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)themeDisplayLocale);
        }
    }
}

