/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal.jmx;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.messaging.internal.jmx.DestinationStatisticsManager;
import com.liferay.portal.messaging.internal.jmx.MessageBusManagerMBean;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"jmx.objectname=com.liferay.portal.messaging:classification=message_bus,name=MessageBusManager", "jmx.objectname.cache.key=MessageBusManager"}, service={DynamicMBean.class})
public class MessageBusManager
extends StandardMBean
implements MessageBusManagerMBean {
    private static final Log _log = LogFactoryUtil.getLog(MessageBusManager.class);
    private BundleContext _bundleContext;
    private final Map<String, ServiceRegistration<DynamicMBean>> _mbeanServiceRegistrations = new ConcurrentHashMap<String, ServiceRegistration<DynamicMBean>>();
    private MessageBus _messageBus;
    private final Set<Destination> _queuedDestinations = Collections.newSetFromMap(new ConcurrentHashMap());

    public MessageBusManager() throws NotCompliantMBeanException {
        super(MessageBusManagerMBean.class);
    }

    @Override
    public int getDestinationCount() {
        return this._messageBus.getDestinationCount();
    }

    @Override
    public int getMessageListenerCount(String destinationName) {
        Destination destination = this._messageBus.getDestination(destinationName);
        if (destination == null) {
            return 0;
        }
        return destination.getMessageListenerCount();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        for (Destination destination : this._queuedDestinations) {
            this.addDestination(destination);
        }
        this._queuedDestinations.clear();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(destination.name=*)")
    protected void addDestination(Destination destination) {
        block3: {
            if (this._bundleContext == null) {
                this._queuedDestinations.add(destination);
                return;
            }
            try {
                DestinationStatisticsManager destinationStatisticsManager = new DestinationStatisticsManager(destination);
                HashMapDictionary mBeanProperties = HashMapDictionaryBuilder.put((Object)"jmx.objectname", (Object)destinationStatisticsManager.getObjectName()).put((Object)"jmx.objectname.cache.key", (Object)destinationStatisticsManager.getObjectNameCacheKey()).build();
                ServiceRegistration serviceRegistration = this._bundleContext.registerService(DynamicMBean.class, (Object)destinationStatisticsManager, (Dictionary)mBeanProperties);
                this._mbeanServiceRegistrations.put(destination.getName(), (ServiceRegistration<DynamicMBean>)serviceRegistration);
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                if (!_log.isInfoEnabled()) break block3;
                _log.info((Object)"Unable to register destination mbean", (Throwable)notCompliantMBeanException);
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        this._mbeanServiceRegistrations.clear();
    }

    protected void removeDestination(Destination destination) {
        ServiceRegistration<DynamicMBean> mbeanServiceRegistration = this._mbeanServiceRegistrations.remove(destination.getName());
        if (mbeanServiceRegistration != null) {
            mbeanServiceRegistration.unregister();
        }
    }

    @Reference(unbind="-")
    protected void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }
}

