/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal.sender;

import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.messaging.internal.sender.SynchronousMessageListener;
import java.util.Map;
import java.util.UUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"mode=DEFAULT", "timeout=10000"}, service={SynchronousMessageSender.class})
public class DefaultSynchronousMessageSender
implements SynchronousMessageSender {
    private static final Log _log = LogFactoryUtil.getLog(DefaultSynchronousMessageSender.class);
    @Reference
    private EntityCache _entityCache;
    @Reference
    private FinderCache _finderCache;
    @Reference
    private MessageBus _messageBus;
    private long _timeout;

    public Object send(String destinationName, Message message) throws MessageBusException {
        return this.send(destinationName, message, this._timeout);
    }

    public Object send(String destinationName, Message message, long timeout) throws MessageBusException {
        Destination destination = this._messageBus.getDestination(destinationName);
        if (destination == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Destination " + destinationName + " is not configured"));
            }
            return null;
        }
        if (destination.getMessageListenerCount() == 0) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Destination " + destinationName + " does not have any message listeners"));
            }
            return null;
        }
        message.setDestinationName(destinationName);
        String responseDestinationName = message.getResponseDestinationName();
        if (Validator.isNull((String)responseDestinationName) || !this._messageBus.hasDestination(responseDestinationName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response destination " + responseDestinationName + " is not configured"));
            }
            message.setResponseDestinationName("liferay/message_bus/default_response");
        }
        message.setResponseId(this.generateUUID());
        SynchronousMessageListener synchronousMessageListener = new SynchronousMessageListener(this._messageBus, message, timeout, this._entityCache, this._finderCache);
        return synchronousMessageListener.send();
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._timeout = GetterUtil.getLong((Object)properties.get("timeout"), (long)10000L);
    }

    protected String generateUUID() {
        UUID uuid = new UUID(SecureRandomUtil.nextLong(), SecureRandomUtil.nextLong());
        return uuid.toString();
    }
}

