/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.cors.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CORSSupport {
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ORIGIN = "Origin";
    private static final Log _log = LogFactoryUtil.getLog(CORSSupport.class);
    private final Map<String, String> _corsHeaders = new HashMap<String, String>();

    public static Map<String, String> buildCORSHeaders(String[] corsHeaderStrings) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String header : corsHeaderStrings) {
            int index = header.indexOf(58);
            if (index < 1) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Incorrect CORS header: " + header));
                continue;
            }
            headers.put(StringUtil.trim((String)header.substring(0, index)), StringUtil.trim((String)header.substring(index + 1)));
        }
        return headers;
    }

    public boolean isCORSRequest(Function<String, String> requestHeadersFunction) {
        String origin = requestHeadersFunction.apply(ORIGIN);
        return !Validator.isBlank((String)origin);
    }

    public boolean isValidCORSPreflightRequest(Function<String, String> requestHeadersFunction) {
        String origin = requestHeadersFunction.apply(ORIGIN);
        if (!this.isValidOrigin(origin)) {
            return false;
        }
        String accessControlRequestMethod = requestHeadersFunction.apply(ACCESS_CONTROL_REQUEST_METHOD);
        if (Validator.isBlank((String)accessControlRequestMethod)) {
            return false;
        }
        String accessControlAllowedMethods = this._corsHeaders.get(ACCESS_CONTROL_ALLOW_METHODS);
        return StringUtil.equals((String)accessControlAllowedMethods, (String)"*") || ArrayUtil.contains((Object[])StringUtil.split((String)accessControlAllowedMethods), (Object)accessControlRequestMethod);
    }

    public boolean isValidCORSRequest(String httpMethod, Function<String, String> requestHeadersFunction) {
        if (!this.isValidOrigin(requestHeadersFunction.apply(ORIGIN))) {
            return false;
        }
        String accessControlAllowedMethods = this._corsHeaders.get(ACCESS_CONTROL_ALLOW_METHODS);
        return StringUtil.equals((String)accessControlAllowedMethods, (String)"*") || ArrayUtil.contains((Object[])StringUtil.split((String)accessControlAllowedMethods), (Object)httpMethod);
    }

    public boolean isValidOrigin(String origin) {
        if (Validator.isBlank((String)origin)) {
            return false;
        }
        String accessControlAllowOrigin = this._corsHeaders.get(ACCESS_CONTROL_ALLOW_ORIGIN);
        if (Validator.isBlank((String)accessControlAllowOrigin)) {
            return true;
        }
        if (StringUtil.equals((String)accessControlAllowOrigin, (String)"*")) {
            return true;
        }
        return ArrayUtil.contains((Object[])StringUtil.split((String)accessControlAllowOrigin), (Object)origin);
    }

    public void setCORSHeaders(Map<String, String> corsHeaders) {
        this._corsHeaders.putAll(corsHeaders);
    }

    public void setHeader(String key, String value) {
        this._corsHeaders.put(key, value);
    }

    public void writeResponseHeaders(Function<String, String> requestHeadersFunction, BiConsumer<String, String> responseHeadersBiConsumer) {
        String origin = requestHeadersFunction.apply(ORIGIN);
        responseHeadersBiConsumer.accept(ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        for (Map.Entry<String, String> entry : this._corsHeaders.entrySet()) {
            String key = entry.getKey();
            if (StringUtil.equals((String)key, (String)ACCESS_CONTROL_ALLOW_ORIGIN)) continue;
            responseHeadersBiConsumer.accept(key, entry.getValue());
        }
    }
}

