/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.cors.internal.servlet.filter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.remote.cors.internal.CORSSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CORSServletFilter
implements Filter {
    protected final CORSSupport corsSupport = new CORSSupport();

    public void destroy() {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (this.corsSupport.isCORSRequest(arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0))) {
            try {
                this.processCORSRequest(httpServletRequest, (HttpServletResponse)servletResponse, filterChain);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void processCORSRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        if (StringUtil.equals((String)"OPTIONS", (String)httpServletRequest.getMethod())) {
            if (this.corsSupport.isValidCORSPreflightRequest(arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0))) {
                this.corsSupport.writeResponseHeaders(arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0), (arg_0, arg_1) -> ((HttpServletResponse)httpServletResponse).setHeader(arg_0, arg_1));
            }
            return;
        }
        if (this.corsSupport.isValidCORSRequest(httpServletRequest.getMethod(), arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0))) {
            this.corsSupport.writeResponseHeaders(arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0), (arg_0, arg_1) -> ((HttpServletResponse)httpServletResponse).setHeader(arg_0, arg_1));
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void setCORSHeaders(Map<String, String> corsHeaders) {
        this.corsSupport.setCORSHeaders(corsHeaders);
    }
}

