/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.cors.internal.servlet.filter;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.remote.cors.configuration.WebContextCORSConfiguration;
import com.liferay.portal.remote.cors.internal.CORSSupport;
import com.liferay.portal.remote.cors.internal.servlet.filter.CORSServletFilter;
import java.util.Dictionary;
import java.util.Map;
import javax.servlet.Filter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.remote.cors.configuration.WebContextCORSConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={})
public class CORSServletFilterServletContextHelperTracker {
    private BundleContext _bundleContext;
    private Map<String, String> _corsHeaders;
    private String[] _filterMappingUrlPatterns;
    private ServiceTracker<ServletContextHelper, ServiceRegistration<?>> _serviceTracker;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        WebContextCORSConfiguration webContextCORSConfiguration = (WebContextCORSConfiguration)ConfigurableUtil.createConfigurable(WebContextCORSConfiguration.class, properties);
        this._corsHeaders = CORSSupport.buildCORSHeaders(webContextCORSConfiguration.headers());
        this._filterMappingUrlPatterns = webContextCORSConfiguration.filterMappingURLPatterns();
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, (String)StringBundler.concat((String[])new String[]{"(&", webContextCORSConfiguration.servletContextHelperSelectFilter(), "(", "osgi.http.whiteboard.context.name", "=*)(objectClass=", ServletContextHelper.class.getName(), "))"}), (ServiceTrackerCustomizer)new ServletContextHelperServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class ServletContextHelperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServletContextHelper, ServiceRegistration<?>> {
        private ServletContextHelperServiceTrackerCustomizer() {
        }

        public ServiceRegistration<?> addingService(ServiceReference<ServletContextHelper> serviceReference) {
            CORSServletFilter corsServletFilter = new CORSServletFilter();
            corsServletFilter.setCORSHeaders(CORSServletFilterServletContextHelperTracker.this._corsHeaders);
            return CORSServletFilterServletContextHelperTracker.this._bundleContext.registerService(Filter.class, (Object)corsServletFilter, this._buildProperties(serviceReference));
        }

        public void modifiedService(ServiceReference<ServletContextHelper> serviceReference, ServiceRegistration<?> serviceRegistration) {
            serviceRegistration.setProperties(this._buildProperties(serviceReference));
        }

        public void removedService(ServiceReference<ServletContextHelper> serviceReference, ServiceRegistration<?> serviceRegistration) {
            try {
                serviceRegistration.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private Dictionary<String, Object> _buildProperties(ServiceReference<ServletContextHelper> serviceReference) {
            HashMapDictionary properties = new HashMapDictionary();
            properties.put("service.ranking", -1);
            properties.put("osgi.http.whiteboard.context.select", GetterUtil.getString((Object)serviceReference.getProperty("osgi.http.whiteboard.context.name")));
            properties.put("osgi.http.whiteboard.filter.name", CORSServletFilter.class.getName());
            if (ArrayUtil.isEmpty((Object[])CORSServletFilterServletContextHelperTracker.this._filterMappingUrlPatterns) || ArrayUtil.contains((Object[])CORSServletFilterServletContextHelperTracker.this._filterMappingUrlPatterns, (Object)"*")) {
                properties.put("osgi.http.whiteboard.filter.servlet", "cxf-servlet");
            } else {
                properties.put("osgi.http.whiteboard.filter.pattern", CORSServletFilterServletContextHelperTracker.this._filterMappingUrlPatterns);
            }
            return properties;
        }
    }
}

