/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.cors.internal.servlet.filter;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.remote.cors.configuration.PortalCORSConfiguration;
import com.liferay.portal.remote.cors.internal.CORSSupport;
import com.liferay.portal.remote.cors.internal.servlet.filter.CORSServletFilter;
import java.util.Dictionary;
import java.util.Map;
import javax.servlet.Filter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.portal.remote.cors.configuration.PortalCORSConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={})
public class ConfigurablePortalCORSServletFilterPublisher {
    private ServiceRegistration<Filter> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        PortalCORSConfiguration portalCORSConfiguration = (PortalCORSConfiguration)ConfigurableUtil.createConfigurable(PortalCORSConfiguration.class, properties);
        if (!portalCORSConfiguration.enabled()) {
            return;
        }
        Map<String, String> corsHeaders = CORSSupport.buildCORSHeaders(portalCORSConfiguration.headers());
        CORSServletFilter corsServletFilter = new CORSServletFilter();
        corsServletFilter.setCORSHeaders(corsHeaders);
        HashMapDictionary filterProperties = new HashMapDictionary();
        filterProperties.put("before-filter", "Auto Login Filter");
        filterProperties.put("dispatcher", new String[]{"FORWARD", "REQUEST"});
        filterProperties.put("servlet-context-name", "");
        filterProperties.put("servlet-filter-name", "CORS Servlet Filter for " + portalCORSConfiguration.name());
        filterProperties.put("url-pattern", portalCORSConfiguration.filterMappingURLPatterns());
        this._serviceRegistration = bundleContext.registerService(Filter.class, (Object)corsServletFilter, (Dictionary)filterProperties);
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
        this._serviceRegistration = null;
    }
}

