/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.cors.internal.jaxrs.feature;

import com.liferay.petra.reflect.AnnotationLocator;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.remote.cors.annotation.CORS;
import com.liferay.portal.remote.cors.internal.CORSSupport;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(property={"osgi.jaxrs.application.select=(liferay.cors.annotation=true)", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=Liferay.CORS.Annotation.Extension"}, scope=ServiceScope.PROTOTYPE, service={DynamicFeature.class})
public class CORSAnnotationDynamicFeature
implements DynamicFeature {
    @Context
    private ResourceInfo _resourceInfo;

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        CORS cors = this.getCORS(resourceInfo);
        if (cors != null) {
            CORSSupport corsSupport = this.getCORSSupport(cors);
            context.register((Object)new CORSPreflighContainerRequestFilter(corsSupport));
            context.register((Object)this.buildCORSResponseFilter(corsSupport));
        }
    }

    protected ContainerResponseFilter buildCORSResponseFilter(CORSSupport corsSupport) {
        return (containerRequestContext, containerResponseContext) -> {
            MultivaluedMap headers = containerRequestContext.getHeaders();
            if (corsSupport.isCORSRequest(arg_0 -> ((MultivaluedMap)headers).getFirst(arg_0))) {
                if (corsSupport.isValidCORSRequest(containerRequestContext.getMethod(), arg_0 -> ((MultivaluedMap)headers).getFirst(arg_0))) {
                    MultivaluedMap responseHeaders = containerResponseContext.getHeaders();
                    corsSupport.writeResponseHeaders(arg_0 -> ((MultivaluedMap)headers).getFirst(arg_0), (arg_0, arg_1) -> ((MultivaluedMap)responseHeaders).addFirst(arg_0, arg_1));
                }
            }
        };
    }

    protected CORS getCORS(ResourceInfo resourceInfo) {
        return (CORS)AnnotationLocator.locate((Method)resourceInfo.getResourceMethod(), (Class)resourceInfo.getResourceClass(), CORS.class);
    }

    protected CORSSupport getCORSSupport(CORS cors) {
        CORSSupport corsSupport = new CORSSupport();
        HashMap corsHeaders = HashMapBuilder.put((Object)"Access-Control-Allow-Credentials", (Object)String.valueOf(cors.allowCredentials())).put((Object)"Access-Control-Allow-Headers", (Object)StringUtil.merge((Object[])cors.allowHeaders(), (String)",")).put((Object)"Access-Control-Allow-Methods", (Object)StringUtil.merge((Object[])cors.allowMethods(), (String)",")).put((Object)"Access-Control-Allow-Origin", (Object)cors.allowOrigin()).put((Object)"Access-Control-Expose-Headers", (Object)StringUtil.merge((Object[])cors.exposeHeaders(), (String)",")).put((Object)"Access-Control-Max-Age", (Object)String.valueOf(cors.maxAge())).build();
        corsSupport.setCORSHeaders(corsHeaders);
        return corsSupport;
    }

    @PreMatching
    private static class CORSPreflighContainerRequestFilter
    implements ContainerRequestFilter {
        private final CORSSupport _corsSupport;

        public CORSPreflighContainerRequestFilter(CORSSupport corsSupport) {
            this._corsSupport = corsSupport;
        }

        public void filter(ContainerRequestContext containerRequestContext) throws IOException {
            MultivaluedMap headers = containerRequestContext.getHeaders();
            if (this._corsSupport.isCORSRequest(arg_0 -> ((MultivaluedMap)headers).getFirst(arg_0)) && StringUtil.equals((String)containerRequestContext.getMethod(), (String)"OPTIONS")) {
                if (this._corsSupport.isValidCORSPreflightRequest(arg_0 -> ((MultivaluedMap)headers).getFirst(arg_0))) {
                    Response.ResponseBuilder responseBuilder = Response.ok();
                    this._corsSupport.writeResponseHeaders(arg_0 -> ((MultivaluedMap)headers).getFirst(arg_0), (arg_0, arg_1) -> ((Response.ResponseBuilder)responseBuilder).header(arg_0, arg_1));
                    containerRequestContext.abortWith(responseBuilder.build());
                }
            }
        }
    }
}

