/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.rest.internal.resource.v1_0;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayRenderRequest;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.rest.configuration.SearchSuggestionsCompanyConfiguration;
import com.liferay.portal.search.rest.dto.v1_0.Suggestion;
import com.liferay.portal.search.rest.dto.v1_0.SuggestionsContributorConfiguration;
import com.liferay.portal.search.rest.internal.resource.v1_0.BaseSuggestionResourceImpl;
import com.liferay.portal.search.rest.resource.v1_0.SuggestionResource;
import com.liferay.portal.search.suggestions.SuggestionsContributorResults;
import com.liferay.portal.search.suggestions.SuggestionsRetriever;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portlet.RenderRequestFactory;
import com.liferay.portlet.RenderResponseFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(configurationPid={"com.liferay.portal.search.rest.configuration.SearchSuggestionsCompanyConfiguration"}, properties={"OSGI-INF/liferay/rest/v1_0/suggestion.properties"}, scope=ServiceScope.PROTOTYPE, service={SuggestionResource.class})
public class SuggestionResourceImpl
extends BaseSuggestionResourceImpl {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    private volatile SearchSuggestionsCompanyConfiguration _searchSuggestionsCompanyConfiguration;
    @Reference
    private SuggestionsRetriever _suggestionsRetriever;

    @Override
    public Page<com.liferay.portal.search.rest.dto.v1_0.SuggestionsContributorResults> postSuggestionsPage(String currentURL, String destinationFriendlyURL, Long groupId, Long plid, String scope, String search, SuggestionsContributorConfiguration[] suggestionsContributorConfigurations) throws Exception {
        if (!this._searchSuggestionsCompanyConfiguration.enableSuggestionsEndpoint() || suggestionsContributorConfigurations == null) {
            return Page.of(Collections.emptyList());
        }
        LiferayRenderRequest liferayRenderRequest = this._createLiferayRenderRequest(currentURL, plid);
        return Page.of(this.transform(this._suggestionsRetriever.getSuggestionsContributorResults((LiferayPortletRequest)liferayRenderRequest, (LiferayPortletResponse)RenderResponseFactory.create((HttpServletResponse)this.contextHttpServletResponse, (RenderRequest)liferayRenderRequest), this._createSearchContext(destinationFriendlyURL, this._getGroupId(groupId), scope, search, suggestionsContributorConfigurations)), suggestionsContributorResult -> new com.liferay.portal.search.rest.dto.v1_0.SuggestionsContributorResults((SuggestionsContributorResults)suggestionsContributorResult){
            final /* synthetic */ SuggestionsContributorResults val$suggestionsContributorResult;
            {
                this.val$suggestionsContributorResult = suggestionsContributorResults;
                this.attributes = this.val$suggestionsContributorResult.getAttributes();
                this.displayGroupName = this.val$suggestionsContributorResult.getDisplayGroupName();
                this.suggestions = (Suggestion[])SuggestionResourceImpl.this.transformToArray(this.val$suggestionsContributorResult.getSuggestions(), suggestion -> new Suggestion((com.liferay.portal.search.suggestions.Suggestion)suggestion){
                    final /* synthetic */ com.liferay.portal.search.suggestions.Suggestion val$suggestion;
                    {
                        this.val$suggestion = suggestion;
                        this.attributes = this.val$suggestion.getAttributes();
                        this.score = Float.valueOf(this.val$suggestion.getScore());
                        this.text = this.val$suggestion.getText();
                    }
                }, Suggestion.class);
            }
        }));
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._searchSuggestionsCompanyConfiguration = (SearchSuggestionsCompanyConfiguration)ConfigurableUtil.createConfigurable(SearchSuggestionsCompanyConfiguration.class, properties);
    }

    private LiferayRenderRequest _createLiferayRenderRequest(String currentURL, long plid) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(plid);
        this.contextHttpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)this._createThemeDisplay(currentURL, layout));
        Portlet portlet = this._portletLocalService.getPortletById("com_liferay_portal_search_web_search_bar_portlet_SearchBarPortlet");
        ServletContext servletContext = (ServletContext)this.contextHttpServletRequest.getAttribute("CTX");
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        LiferayRenderRequest liferayRenderRequest = RenderRequestFactory.create((HttpServletRequest)this.contextHttpServletRequest, (Portlet)portlet, (InvokerPortlet)PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext), (PortletContext)portletConfig.getPortletContext(), (WindowState)WindowState.NORMAL, (PortletMode)PortletMode.VIEW, null, (long)layout.getPlid());
        liferayRenderRequest.setPortletRequestDispatcherRequest(this.contextHttpServletRequest);
        liferayRenderRequest.defineObjects(portletConfig, (PortletResponse)RenderResponseFactory.create((HttpServletResponse)this.contextHttpServletResponse, (RenderRequest)liferayRenderRequest));
        return liferayRenderRequest;
    }

    private SearchContext _createSearchContext(String destinationFriendlyURL, long groupId, String scope, String search, SuggestionsContributorConfiguration[] suggestionsContributorConfigurations) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("search.experiences.ip.address", (Serializable)((Object)this.contextHttpServletRequest.getRemoteAddr()));
        searchContext.setAttribute("search.experiences.scope.group.id", (Serializable)Long.valueOf(groupId));
        searchContext.setAttribute("search.suggestions.contributor.configurations", (Serializable)suggestionsContributorConfigurations);
        searchContext.setAttribute("search.suggestions.destination.friendly.url", (Serializable)((Object)destinationFriendlyURL));
        searchContext.setCompanyId(this.contextCompany.getCompanyId());
        if (!StringUtil.equals((String)scope, (String)"everything")) {
            searchContext.setGroupIds(new long[]{groupId});
        }
        searchContext.setKeywords(search);
        searchContext.setLocale(this.contextAcceptLanguage.getPreferredLocale());
        searchContext.setTimeZone(this.contextUser.getTimeZone());
        searchContext.setUserId(this.contextUser.getUserId());
        return searchContext;
    }

    private ThemeDisplay _createThemeDisplay(String currentURL, Layout layout) throws Exception {
        ThemeDisplay themeDisplay = new ThemeDisplay();
        themeDisplay.setCompany(this.contextCompany);
        themeDisplay.setLayout(layout);
        themeDisplay.setPathMain(this._portal.getPathMain());
        themeDisplay.setPermissionChecker(PermissionThreadLocal.getPermissionChecker());
        themeDisplay.setPlid(layout.getPlid());
        themeDisplay.setRequest(this.contextHttpServletRequest);
        themeDisplay.setScopeGroupId(layout.getGroupId());
        themeDisplay.setSiteGroupId(layout.getGroupId());
        themeDisplay.setURLCurrent(currentURL);
        themeDisplay.setUser(this.contextUser);
        return themeDisplay;
    }

    private long _getGroupId(Long groupId) {
        if (groupId != null) {
            return groupId;
        }
        try {
            return this.contextCompany.getGroupId();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }
}

