/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.rest.internal.security.service.access.policy;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class SuggestionsSAPEntryActivator {
    private static final String[] _SAP_ENTRY_OBJECT_ARRAY = new String[]{"SEARCH_SUGGESTIONS", "com.liferay.portal.search.rest.internal.resource.v1_0.SuggestionResourceImpl#postSuggestionsPage"};
    private static final Log _log = LogFactoryUtil.getLog(SuggestionsSAPEntryActivator.class);
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    private ServiceRegistration<PortalInstanceLifecycleListener> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)new SuggestionsPortalInstanceLifecycleListener(), null);
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private void _addSAPEntry(long companyId) throws Exception {
        String name = _SAP_ENTRY_OBJECT_ARRAY[0];
        SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, name);
        if (sapEntry != null) {
            return;
        }
        Map map = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)ResourceBundleLoaderUtil.getPortalResourceBundleLoader(), (String)name);
        this._sapEntryLocalService.addSAPEntry(this._userLocalService.getDefaultUserId(companyId), _SAP_ENTRY_OBJECT_ARRAY[1], true, true, name, map, new ServiceContext());
    }

    private class SuggestionsPortalInstanceLifecycleListener
    extends BasePortalInstanceLifecycleListener {
        private SuggestionsPortalInstanceLifecycleListener() {
        }

        public void portalInstanceRegistered(Company company) throws Exception {
            try {
                SuggestionsSAPEntryActivator.this._addSAPEntry(company.getCompanyId());
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to add service access policy entry for company " + company.getCompanyId()), (Throwable)portalException);
            }
        }
    }
}

