/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.junit.Assert;

public class AssertUtils {
    public static void assertEquals(String message, JSONObject expectedJSONObject, JSONObject actualJSONObject) {
        String actual = AssertUtils._toString(actualJSONObject);
        Assert.assertEquals((String)AssertUtils._getMessage(message, actual), (Object)AssertUtils._toString(expectedJSONObject), (Object)actual);
    }

    public static void assertEquals(String message, List<?> expectedList, List<?> actualList) {
        String actual = actualList.toString();
        Assert.assertEquals((String)AssertUtils._getMessage(message, actual), (Object)expectedList.toString(), (Object)actual);
    }

    public static void assertEquals(String message, Map<?, ?> expectedMap, Map<?, ?> actualMap) {
        AssertUtils.assertEquals(() -> AssertUtils._getMessage(message, actualMap), expectedMap, actualMap);
    }

    public static void assertEquals(Supplier<String> messageSupplier, long expected, long actual) {
        try {
            Assert.assertEquals((long)expected, (long)actual);
        }
        catch (AssertionError assertionError) {
            Assert.assertEquals((String)messageSupplier.get(), (long)expected, (long)actual);
        }
    }

    public static void assertEquals(Supplier<String> messageSupplier, Map<?, ?> expectedMap, List<?> actualList) {
        AssertUtils.assertEquals(messageSupplier, AssertUtils._toMapString(expectedMap), String.valueOf(actualList));
    }

    public static void assertEquals(Supplier<String> messageSupplier, Map<?, ?> expectedMap, Map<?, ?> actualMap) {
        AssertUtils.assertEquals(messageSupplier, AssertUtils._toMapString(expectedMap), AssertUtils._toMapString(actualMap));
    }

    public static void assertEquals(Supplier<String> messageSupplier, String expected, String actual) {
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (AssertionError assertionError) {
            Assert.assertEquals((String)messageSupplier.get(), (Object)expected, (Object)actual);
        }
    }

    private static String _getMessage(String message, Object object) {
        return message + "->" + object;
    }

    private static String _toMapString(Map<?, ?> map) {
        ArrayList<String> list = new ArrayList<String>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            list.add(entry.toString());
        }
        Collections.sort(list);
        return ((Object)list).toString();
    }

    private static String _toString(JSONArray jsonArray) {
        ArrayList list = new ArrayList(jsonArray.length());
        jsonArray.forEach(value -> list.add(AssertUtils._toString(value)));
        Collections.sort(list);
        return "[" + StringUtil.merge(list, (String)",") + "]";
    }

    private static String _toString(JSONObject jsonObject) {
        ArrayList list = new ArrayList(jsonObject.length());
        Iterator keys = jsonObject.keys();
        keys.forEachRemaining(key -> list.add(AssertUtils._toString(key) + ":" + AssertUtils._toString(jsonObject.get(key))));
        Collections.sort(list);
        return "{" + StringUtil.merge(list, (String)",") + "}";
    }

    private static String _toString(Object object) {
        if (object instanceof JSONObject) {
            return AssertUtils._toString((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return AssertUtils._toString((JSONArray)object);
        }
        if (object instanceof String) {
            return AssertUtils._toString((String)object);
        }
        return object.toString();
    }

    private static String _toString(String string) {
        String escapedString = StringUtil.replace((String)string, (char)'\"', (String)"\\\"");
        return "\"" + escapedString + "\"";
    }
}

