/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.HierarchicalAggregationResult;
import com.liferay.portal.search.aggregation.bucket.FilterAggregation;
import com.liferay.portal.search.aggregation.bucket.FilterAggregationResult;
import com.liferay.portal.search.aggregation.metrics.SumAggregation;
import com.liferay.portal.search.aggregation.metrics.SumAggregationResult;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseFilterAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testFilter() {
        this.index("SomeUser1", 1);
        this.index("SomeUser1", 2);
        this.index("SomeUser1", 3);
        this.index("SomeUser2", 4);
        this.index("SomeUser2", 5);
        this.index("SomeUser2", 6);
        this.index("SomeUser2", 7);
        FilterAggregation filterAggregation = this.aggregations.filter("filter", (Query)this.queries.term("userName", (Object)"SomeUser1"));
        SumAggregation sumAggregation = this.aggregations.sum("sum", "priority");
        filterAggregation.addChildAggregation((Aggregation)sumAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)filterAggregation));
            indexingTestHelper.search();
            FilterAggregationResult filterAggregationResult = (FilterAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)filterAggregation);
            Assert.assertEquals((String)"Filtered aggregation results", (long)3L, (long)filterAggregationResult.getDocCount());
            SumAggregationResult sumAggregationResult = (SumAggregationResult)indexingTestHelper.getChildAggregationResult((HierarchicalAggregationResult)filterAggregationResult, (Aggregation)sumAggregation);
            Assert.assertEquals((String)"Sum of priority in results", (double)6.0, (double)sumAggregationResult.getValue(), (double)0.0);
        });
    }

    protected void index(String userName, int priority) {
        this.addDocument((Document document) -> {
            document.addKeyword("userName", userName);
            document.addNumber("priority", priority);
        });
    }
}

