/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.TermsAggregation;
import com.liferay.portal.search.aggregation.bucket.TermsAggregationResult;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregation;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregationResult;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseTopHitsAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testTopHitsAggregation() throws Exception {
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "Jonh");
            document.addNumber("priority", 1);
        });
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "Jonh");
            document.addNumber("priority", 2);
        });
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "Jonh");
            document.addNumber("priority", 3);
        });
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "Bob");
            document.addNumber("priority", 4);
        });
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "Bob");
            document.addNumber("priority", 5);
        });
        TermsAggregation termsAggregation = this.aggregations.terms("terms", "userName");
        TopHitsAggregation topHitsAggregation = this.aggregations.topHits("topHits");
        topHitsAggregation.addSortFields(new Sort[]{this.sorts.field("priority", SortOrder.DESC)});
        topHitsAggregation.setSize(Integer.valueOf(1));
        termsAggregation.addChildAggregation((Aggregation)topHitsAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)termsAggregation));
            indexingTestHelper.search();
            TermsAggregationResult termsAggregationResult = (TermsAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)termsAggregation);
            for (Bucket bucket : termsAggregationResult.getBuckets()) {
                String userName = bucket.getKey();
                if (Objects.equals(userName, "Jonh")) {
                    this.assertBucket(bucket, 3L, 3);
                    continue;
                }
                if (!Objects.equals(userName, "Bob")) continue;
                this.assertBucket(bucket, 2L, 5);
            }
        });
    }

    protected void assertBucket(Bucket bucket, long count, Integer priority) {
        Assert.assertEquals((long)count, (long)bucket.getDocCount());
        Map childrenAggregationResults = bucket.getChildrenAggregationResults();
        TopHitsAggregationResult topHitsAggregationResult = (TopHitsAggregationResult)childrenAggregationResults.get("topHits");
        SearchHits searchHits = topHitsAggregationResult.getSearchHits();
        List searchHitsList = searchHits.getSearchHits();
        SearchHit searchHit = (SearchHit)searchHitsList.get(0);
        com.liferay.portal.search.document.Document document = searchHit.getDocument();
        if (MapUtil.isNotEmpty((Map)document.getFields())) {
            Assert.assertEquals((Object)priority, (Object)document.getInteger("priority"));
        } else {
            Map sourcesMap = searchHit.getSourcesMap();
            Assert.assertEquals((Object)priority.toString(), sourcesMap.get("priority"));
        }
    }
}

