/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.BucketSelectorPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.script.Script;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseBucketSelectorPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testBucketSelector() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        HistogramAggregation histogramAggregation = this.aggregationFixture.getDefaultHistogramAggregation();
        Script script = this.scripts.script("params.sum > 40");
        BucketSelectorPipelineAggregation bucketSelectorPipelineAggregation = this.aggregations.bucketSelector("bucket_selector", script);
        bucketSelectorPipelineAggregation.addBucketPath("sum", "sum");
        histogramAggregation.addPipelineAggregation((PipelineAggregation)bucketSelectorPipelineAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)histogramAggregation));
            indexingTestHelper.search();
            HistogramAggregationResult histogramAggregationResult = (HistogramAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)histogramAggregation);
            ArrayList buckets = new ArrayList(histogramAggregationResult.getBuckets());
            Assert.assertEquals((String)"Number of buckets", (long)2L, (long)buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "10.0", 5L);
            this.assertBucket((Bucket)buckets.get(1), "15.0", 5L);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount) {
        Assert.assertEquals((Object)expectedKey, (Object)bucket.getKey());
        Assert.assertEquals((long)expectedCount, (long)bucket.getDocCount());
    }
}

