/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.BucketAggregationResult;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregationResult;
import com.liferay.portal.search.aggregation.metrics.SumAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.BucketSortPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.test.util.aggregation.AggregationAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Map;
import org.junit.Test;

public abstract class BaseBucketSortPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testBucketSort() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        FieldSort fieldSort = this.sorts.field("sum");
        String expectedBuckets = "[0.0=4, 20.0=1, 5.0=5, 10.0=5, 15.0=5]";
        String expectedBucketValues = "10.0, 20.0, 35.0, 60.0, 85.0";
        HistogramAggregation histogramAggregation = this.aggregationFixture.getDefaultHistogramAggregation();
        BucketSortPipelineAggregation bucketSortPipelineAggregation = this.aggregations.bucketSort("bucket_sort");
        bucketSortPipelineAggregation.addSortFields(new FieldSort[]{fieldSort});
        histogramAggregation.addPipelineAggregation((PipelineAggregation)bucketSortPipelineAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)histogramAggregation));
            indexingTestHelper.search();
            HistogramAggregationResult histogramAggregationResult = (HistogramAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)histogramAggregation);
            AggregationAssert.assertBuckets(expectedBuckets, (BucketAggregationResult)histogramAggregationResult);
            AggregationAssert.assertBucketValues(expectedBucketValues, this::getSumValue, (BucketAggregationResult)histogramAggregationResult);
        });
    }

    @Test
    public void testBucketSortWithSize() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        FieldSort fieldSort = this.sorts.field("sum", SortOrder.DESC);
        String expectedBuckets = "[15.0=5, 10.0=5, 5.0=5]";
        String expectedBucketValues = "85.0, 60.0, 35.0";
        HistogramAggregation histogramAggregation = this.aggregationFixture.getDefaultHistogramAggregation();
        BucketSortPipelineAggregation bucketSortPipelineAggregation = this.aggregations.bucketSort("bucket_sort");
        bucketSortPipelineAggregation.addSortFields(new FieldSort[]{fieldSort});
        bucketSortPipelineAggregation.setSize(Integer.valueOf(3));
        histogramAggregation.addPipelineAggregation((PipelineAggregation)bucketSortPipelineAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)histogramAggregation));
            indexingTestHelper.search();
            HistogramAggregationResult histogramAggregationResult = (HistogramAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)histogramAggregation);
            AggregationAssert.assertBuckets(expectedBuckets, (BucketAggregationResult)histogramAggregationResult);
            AggregationAssert.assertBucketValues(expectedBucketValues, this::getSumValue, (BucketAggregationResult)histogramAggregationResult);
        });
    }

    protected double getSumValue(Bucket bucket) {
        Map childrenAggregationResults = bucket.getChildrenAggregationResults();
        SumAggregationResult sumAggregationResult = (SumAggregationResult)childrenAggregationResults.get("sum");
        return sumAggregationResult.getValue();
    }
}

