/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.json.JSONFactoryImpl;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.test.util.FacetsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import com.liferay.portal.search.test.util.indexing.QueryContributor;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class BaseFacetTestCase
extends BaseIndexingTestCase {
    protected final JSONFactory jsonFactory = new JSONFactoryImpl();

    protected void addDocument(String ... values) throws Exception {
        this.addDocument(DocumentCreationHelpers.singleText(this.getField(), values));
    }

    protected void addDocuments(int count, String ... values) throws Exception {
        for (int i = 0; i < count; ++i) {
            this.addDocument(values);
        }
    }

    protected void assertSearchFacet(Consumer<FacetTestHelper> consumer) throws Exception {
        this.assertSearch(indexingTestHelper -> consumer.accept(new FacetTestHelper((BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper)));
    }

    protected abstract String getField();

    protected Facet initFacet(Facet facet) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        facetConfiguration.setDataJSONObject(this.jsonFactory.createJSONObject());
        return facet;
    }

    protected class FacetTestHelper {
        private final BaseIndexingTestCase.IndexingTestHelper _indexingTestHelper;

        public FacetTestHelper(BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) {
            this._indexingTestHelper = indexingTestHelper;
        }

        public <T extends Facet> T addFacet(Function<SearchContext, ? extends T> function) {
            SearchContext searchContext = this.getSearchContext();
            Facet facet = (Facet)function.apply(searchContext);
            searchContext.addFacet(facet);
            return (T)facet;
        }

        public void assertFrequencies(Facet facet, List<String> expected) {
            FacetsAssert.assertFrequencies(facet.getFieldName(), this.getSearchContext(), expected);
        }

        public void assertResultCount(int expected) {
            this._indexingTestHelper.assertResultCount(expected);
        }

        public void assertValues(String fieldName, List<String> expectedValues) {
            this._indexingTestHelper.assertValues(fieldName, expectedValues);
        }

        public void defineRequest(Consumer<SearchRequestBuilder> searchRequestBuilderConsumer) {
            this._indexingTestHelper.defineRequest(searchRequestBuilderConsumer);
        }

        public SearchContext getSearchContext() {
            return this._indexingTestHelper.getSearchContext();
        }

        public void search() {
            this._indexingTestHelper.search();
        }

        public void setPostFilter(Filter postFilter) {
            this._indexingTestHelper.setPostFilter(postFilter);
        }

        public void setQueryContributor(QueryContributor queryContributor) {
            this._indexingTestHelper.setQueryContributor(queryContributor);
        }

        public void setSearchContextAttribute(String name, Serializable value) {
            this._indexingTestHelper.setSearchContextAttribute(name, value);
        }
    }
}

