/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.search.internal.facet.modified.ModifiedFacetFactoryImpl;
import com.liferay.portal.search.internal.filter.FilterBuildersImpl;
import com.liferay.portal.search.test.util.facet.BaseFacetTestCase;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;

public abstract class BaseModifiedFacetTestCase
extends BaseFacetTestCase {
    @Test
    public void testCustomRange() throws Exception {
        this.addDocument("20170102000000");
        this.addDocument("20170104000000");
        this.addDocument("20170106000000");
        String customRange = "[20170101000000 TO 20170105000000]";
        this.assertSearchFacet(helper -> {
            com.liferay.portal.search.facet.Facet facet = helper.addFacet(this::createFacet);
            this.setCustomRange(facet, customRange);
            helper.search();
            helper.assertFrequencies((Facet)facet, Arrays.asList("[20170101000000 TO 20170105000000]=2"));
        });
    }

    @Test
    public void testRanges() throws Exception {
        this.addDocument("20170102000000");
        String[] configRanges = new String[]{"[11110101010101 TO 19990101010101]", "[19990202020202 TO 22220202020202]"};
        String customRange = "[11110101010101 TO 22220202020202]";
        List<String> expectedRanges = Arrays.asList("[11110101010101 TO 19990101010101]=0", "[11110101010101 TO 22220202020202]=1", "[19990202020202 TO 22220202020202]=1");
        this.assertSearchFacet(helper -> {
            com.liferay.portal.search.facet.Facet facet = helper.addFacet(this::createFacet);
            this.setConfigurationRanges(facet, configRanges);
            this.setCustomRange(facet, customRange);
            helper.search();
            helper.assertFrequencies((Facet)facet, expectedRanges);
        });
    }

    protected com.liferay.portal.search.facet.Facet createFacet(SearchContext searchContext) {
        ModifiedFacetFactoryImpl modifiedFacetFactory = new ModifiedFacetFactoryImpl(){
            {
                this.filterBuilders = new FilterBuildersImpl();
            }
        };
        com.liferay.portal.search.facet.Facet facet = modifiedFacetFactory.newInstance(searchContext);
        this.initFacet((Facet)facet);
        return facet;
    }

    protected com.liferay.portal.search.facet.Facet createFacetWithRangeSelected(String range, SearchContext searchContext) {
        com.liferay.portal.search.facet.Facet facet = this.createFacet(searchContext);
        this.setConfigurationRanges(facet, range);
        facet.select(new String[]{range});
        return facet;
    }

    protected JSONArray createRangeArray(String ... ranges) {
        JSONArray jsonArray = this.jsonFactory.createJSONArray();
        for (String range : ranges) {
            jsonArray.put(this.createRangeArrayElement(range));
        }
        return jsonArray;
    }

    protected JSONObject createRangeArrayElement(String range) {
        JSONObject jsonObject = this.jsonFactory.createJSONObject();
        jsonObject.put("range", range);
        return jsonObject;
    }

    protected void doTestSearchEngineDateMath(String range, int frequency) throws Exception {
        this.assertSearchFacet(facetTestHelper -> {
            com.liferay.portal.search.facet.Facet facet = facetTestHelper.addFacet(searchContext -> this.createFacetWithRangeSelected(range, (SearchContext)searchContext));
            BooleanClause booleanClause = facet.getFacetFilterBooleanClause();
            facetTestHelper.setPostFilter((Filter)booleanClause.getClause());
            facetTestHelper.search();
            facetTestHelper.assertResultCount(frequency);
            facetTestHelper.assertFrequencies((Facet)facet, Arrays.asList(range + "=" + frequency));
        });
    }

    @Override
    protected String getField() {
        return "modified";
    }

    protected void setConfigurationRanges(com.liferay.portal.search.facet.Facet facet, String ... ranges) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        JSONObject jsonObject = facetConfiguration.getData();
        jsonObject.put("ranges", this.createRangeArray(ranges));
    }

    protected void setCustomRange(com.liferay.portal.search.facet.Facet facet, String customRange) {
        SearchContext searchContext = facet.getSearchContext();
        searchContext.setAttribute(facet.getFieldId(), (Serializable)((Object)customRange));
    }
}

