/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.logging;

import com.liferay.portal.kernel.test.CaptureHandler;
import com.liferay.portal.kernel.test.JDKLoggerTestUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;

public class ExpectedLogTestRule
implements TestRule {
    private CaptureHandler _captureHandler;
    private final Level _level;
    private final MatcherBuilder _matcherBuilder = new MatcherBuilder();
    private final String _name;

    public static ExpectedLogTestRule none() {
        return new ExpectedLogTestRule(null, null);
    }

    public static ExpectedLogTestRule with(String name, Level level) {
        return new ExpectedLogTestRule(name, level);
    }

    public Statement apply(final Statement base, org.junit.runner.Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ExpectedLogTestRule.this.configure(ExpectedLogTestRule.this._name, ExpectedLogTestRule.this._level);
                try {
                    base.evaluate();
                    ExpectedLogTestRule.this.verify();
                }
                finally {
                    ExpectedLogTestRule.this.closeCaptureHandler();
                }
            }
        };
    }

    public void configure(Class<?> clazz, Level level) {
        this.configure(clazz.getName(), level);
    }

    public void configure(String name, Level level) {
        if (name == null || level == null) {
            return;
        }
        this.closeCaptureHandler();
        this.openCaptureHandler(name, level);
    }

    public void expect(Matcher<?> matcher) {
        this._matcherBuilder.add(matcher);
    }

    public void expectMessage(Matcher<String> matcher) {
        this.expect(LogOutputMatcher.hasMessage(matcher));
    }

    public void expectMessage(String substring) {
        this.expectMessage((Matcher<String>)CoreMatchers.containsString((String)substring));
    }

    public void verify() {
        if (this._captureHandler == null) {
            return;
        }
        if (!this._matcherBuilder.isAnythingExpected()) {
            return;
        }
        Assert.assertThat((Object)this._captureHandler.getLogRecords(), this._matcherBuilder.build());
    }

    protected void closeCaptureHandler() {
        if (this._captureHandler == null) {
            return;
        }
        this._captureHandler.close();
        this._captureHandler = null;
    }

    protected void openCaptureHandler(String name, Level level) {
        this._captureHandler = JDKLoggerTestUtil.configureJDKLogger((String)name, (Level)level);
    }

    private ExpectedLogTestRule(String name, Level level) {
        this._name = name;
        this._level = level;
    }

    protected class MatcherBuilder<T> {
        protected final List<Matcher<T>> matchers = new ArrayList<Matcher<T>>();

        protected MatcherBuilder() {
        }

        protected void add(Matcher<T> matcher) {
            this.matchers.add(matcher);
        }

        protected Matcher<?> build() {
            if (this.matchers.size() == 1) {
                return this.matchers.get(0);
            }
            return CoreMatchers.allOf(new ArrayList<Matcher<T>>(this.matchers));
        }

        protected boolean isAnythingExpected() {
            return !this.matchers.isEmpty();
        }
    }

    protected static class LogOutputMatcher<T extends List<LogRecord>>
    extends TypeSafeMatcher<T> {
        protected final Matcher<String> matcher;

        @Factory
        public static <T extends List<LogRecord>> Matcher<T> hasMessage(Matcher<String> matcher) {
            return new LogOutputMatcher<T>(matcher);
        }

        public LogOutputMatcher(Matcher<String> matcher) {
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("log output with message ");
            description.appendDescriptionOf(this.matcher);
        }

        protected void describeMismatchSafely(T logRecords, Description description) {
            description.appendText("log output ");
            this.matcher.describeMismatch((Object)this.toString(logRecords), description);
        }

        protected boolean matchesSafely(T logRecords) {
            return this.matcher.matches((Object)this.toString(logRecords));
        }

        protected String toString(T logRecords) {
            Stream stream = logRecords.stream();
            return stream.map(LogRecord::getMessage).collect(Collectors.joining());
        }
    }
}

