/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.sort;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.search.internal.SortFactoryImpl;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelper;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Date;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.Test;

public abstract class BaseSortTestCase
extends BaseIndexingTestCase {
    @Test
    public void testDefaultSorts() throws Exception {
        this.addDocuments((Double value) -> document -> {
            document.addDate("modified", new Date(value.longValue()));
            document.addNumber("priority", value);
        }, 1.0, 2.0, 3.0);
        SortFactoryImpl sortFactory = new SortFactoryImpl();
        this.assertOrder(sortFactory.getDefaultSorts(), "priority", "[3.0, 2.0, 1.0]");
    }

    @Test
    public void testPriorityField() throws Exception {
        this.testDoubleField("priority");
    }

    @Test
    public void testPriorityFieldSortable() throws Exception {
        this.testDoubleFieldSortable("priority");
    }

    @Test
    public void testScore() throws Exception {
        String fieldName = "testField";
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(fieldName, value), Stream.of("alpha", "charlie"));
        Query query = this.getScoredQuery(fieldName, "charlie");
        this.assertOrder(this.getScoreSortArray(9, false), fieldName, "[charlie, alpha]", query);
        this.assertOrder(this.getScoreSortArray(9, true), fieldName, "[alpha, charlie]", query);
        this.assertOrder(this.getScoreSortArray(0, false), fieldName, "[charlie, alpha]", query);
        this.assertOrder(this.getScoreSortArray(0, true), fieldName, "[alpha, charlie]", query);
    }

    protected void addDocuments(Function<Double, DocumentCreationHelper> function, double ... values) throws Exception {
        for (double value : values) {
            this.addDocument(function.apply(value));
        }
    }

    protected void assertOrder(Sort[] sorts, String fieldName, String expected) {
        this.assertOrder(sorts, fieldName, expected, null);
    }

    protected void assertOrder(Sort[] sorts, String fieldName, String expected, Query query) {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> searchContext.setSorts(sorts));
            if (query != null) {
                indexingTestHelper.setQuery(query);
            }
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> DocumentsAssert.assertValues(indexingTestHelper.getRequestString(), hits.getDocs(), fieldName, expected));
        });
    }

    protected void assertOrder(String fieldName, int sortType, boolean reverse, String expected) {
        this.assertOrder(new Sort[]{new Sort(fieldName, sortType, reverse)}, fieldName, expected);
    }

    protected Query getScoredQuery(String fieldName, String fieldValue) {
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        booleanQueryImpl.addExactTerm(fieldName, fieldValue);
        booleanQueryImpl.add(this.getDefaultQuery(), BooleanClauseOccur.SHOULD);
        return booleanQueryImpl;
    }

    protected abstract String getScoreParameter();

    protected Sort[] getScoreSortArray(int type, boolean reverse) {
        return new Sort[]{new Sort(this.getScoreParameter(), type, reverse)};
    }

    protected void testDoubleField(String fieldName) throws Exception {
        this.testDoubleField(fieldName, value -> DocumentCreationHelpers.singleNumber(fieldName, value));
    }

    protected void testDoubleField(String fieldName, Function<Double, DocumentCreationHelper> function) throws Exception {
        this.addDocuments(function, 10.0, 1.0, 40.0, 5.3);
        this.assertOrder(fieldName, 7, false, "[1.0, 5.3, 10.0, 40.0]");
        this.assertOrder(fieldName, 7, true, "[40.0, 10.0, 5.3, 1.0]");
    }

    protected void testDoubleFieldSortable(String fieldName) throws Exception {
        this.testDoubleField(fieldName, value -> DocumentCreationHelpers.singleNumberSortable(fieldName, value));
    }
}

