/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ClassNameWrapper;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.result.SearchResultTranslator;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalServiceWrapper;
import com.liferay.portal.kernel.test.util.PropsTestUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.search.test.util.SearchTestUtil;
import com.liferay.registry.BasicRegistryImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerMap;
import com.liferay.registry.collections.ServiceTrackerMapFactory;
import com.liferay.registry.collections.ServiceTrackerMapFactoryUtil;
import com.liferay.registry.collections.ServiceTrackerMapListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;

public abstract class BaseSearchResultUtilTestCase {
    protected ClassNameLocalService classNameLocalService;
    protected SearchResultTranslator searchResultTranslator;

    @Before
    public void setUp() throws Exception {
        this.setUpRegistryUtil();
        this.setUpClassNameLocalService();
        this.setUpFastDateFormatFactoryUtil();
        this.setUpPropsUtil();
        this.setUpSearchResultTranslator();
        this.setUpServiceTrackerMapFactory();
    }

    protected void assertEmptyCommentRelatedSearchResults(SearchResult searchResult) {
        List commentRelatedSearchResults = searchResult.getCommentRelatedSearchResults();
        Assert.assertTrue((String)commentRelatedSearchResults.toString(), (boolean)commentRelatedSearchResults.isEmpty());
    }

    protected void assertEmptyFileEntryRelatedSearchResults(SearchResult searchResult) {
        List fileEntryRelatedSearchResults = searchResult.getFileEntryRelatedSearchResults();
        Assert.assertTrue((String)fileEntryRelatedSearchResults.toString(), (boolean)fileEntryRelatedSearchResults.isEmpty());
    }

    protected void assertEmptyVersions(SearchResult searchResult) {
        List versions = searchResult.getVersions();
        Assert.assertTrue((String)versions.toString(), (boolean)versions.isEmpty());
    }

    protected SearchResult assertOneSearchResult(Document document) {
        List<SearchResult> searchResults = SearchTestUtil.getSearchResults(this.searchResultTranslator, document);
        Assert.assertEquals((String)searchResults.toString(), (long)1L, (long)searchResults.size());
        return searchResults.get(0);
    }

    protected abstract SearchResultTranslator createSearchResultTranslator();

    protected void setUpClassNameLocalService() {
        this.classNameLocalService = new ClassNameLocalServiceWrapper(null){

            public ClassName getClassName(long classNameId) {
                if (classNameId == SearchTestUtil.ATTACHMENT_OWNER_CLASS_NAME_ID) {
                    return new ClassNameWrapper(null){

                        public String getClassName() {
                            return SearchTestUtil.ATTACHMENT_OWNER_CLASS_NAME;
                        }
                    };
                }
                return null;
            }
        };
    }

    protected void setUpFastDateFormatFactoryUtil() {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory((FastDateFormatFactory)ProxyFactory.newDummyInstance(FastDateFormatFactory.class));
    }

    protected void setUpPropsUtil() {
        PropsTestUtil.setProps(Collections.emptyMap());
    }

    protected void setUpRegistryUtil() {
        RegistryUtil.setRegistry((Registry)new BasicRegistryImpl());
    }

    protected void setUpSearchResultTranslator() {
        this.searchResultTranslator = this.createSearchResultTranslator();
    }

    protected void setUpServiceTrackerMapFactory() {
        ServiceTrackerMapFactoryUtil.setServiceTrackerMapFactory((ServiceTrackerMapFactory)new MockServiceTrackerMapFactory());
    }

    private class MockServiceTrackerMapFactory
    implements ServiceTrackerMapFactory {
        private MockServiceTrackerMapFactory() {
        }

        public <S> ServiceTrackerMap<String, List<S>> openMultiValueMap(Class<S> clazz, String propertyKey) {
            return new MockServiceTrackerMap<String, List<S>>();
        }

        public <K, S> ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper) {
            return new MockServiceTrackerMap();
        }

        public <K, S> ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper, Comparator<ServiceReference<S>> comparator) {
            return new MockServiceTrackerMap();
        }

        public <K, S> ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper, ServiceTrackerMapListener<K, ? super S, List<S>> serviceTrackerMapListener) {
            return new MockServiceTrackerMap();
        }

        public <K, SR, S> ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<SR> clazz, String filterString, ServiceReferenceMapper<K, ? super SR> serviceReferenceMapper, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer) {
            return new MockServiceTrackerMap();
        }

        public <K, SR, S> ServiceTrackerMap<K, List<S>> openMultiValueMap(Class<SR> clazz, String filterString, ServiceReferenceMapper<K, ? super SR> serviceReferenceMapper, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer, Comparator<ServiceReference<SR>> comparator) {
            return new MockServiceTrackerMap();
        }

        public <SR, S> ServiceTrackerMap<String, List<S>> openMultiValueMap(Class<SR> clazz, String propertyKey, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer) {
            return new MockServiceTrackerMap<String, List<S>>();
        }

        public <S> ServiceTrackerMap<String, S> openSingleValueMap(Class<S> clazz, String propertyKey) {
            return new MockServiceTrackerMap();
        }

        public <K, S> ServiceTrackerMap<K, S> openSingleValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper) {
            return new MockServiceTrackerMap();
        }

        public <K, S> ServiceTrackerMap<K, S> openSingleValueMap(Class<S> clazz, String filterString, ServiceReferenceMapper<K, ? super S> serviceReferenceMapper, Comparator<ServiceReference<S>> comparator) {
            return new MockServiceTrackerMap();
        }

        public <K, SR, S> ServiceTrackerMap<K, S> openSingleValueMap(Class<SR> clazz, String filterString, ServiceReferenceMapper<K, ? super SR> serviceReferenceMapper, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer) {
            return new MockServiceTrackerMap();
        }

        public <K, SR, S> ServiceTrackerMap<K, S> openSingleValueMap(Class<SR> clazz, String filterString, ServiceReferenceMapper<K, ? super SR> serviceReferenceMapper, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer, Comparator<ServiceReference<SR>> comparator) {
            return new MockServiceTrackerMap();
        }

        public <SR, S> ServiceTrackerMap<String, S> openSingleValueMap(Class<SR> clazz, String propertyKey, ServiceTrackerCustomizer<SR, S> serviceTrackerCustomizer) {
            return new MockServiceTrackerMap();
        }
    }

    private class MockServiceTrackerMap<K, S>
    implements ServiceTrackerMap<K, S> {
        private MockServiceTrackerMap() {
        }

        public void close() {
        }

        public boolean containsKey(K key) {
            return false;
        }

        public S getService(K key) {
            return null;
        }

        public Set<K> keySet() {
            return null;
        }
    }
}

