/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.test.util.IdempotentRetryAssert;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class SearchRetryFixture {
    private Integer _attempts;
    private Integer _timeout;
    private TimeUnit _timeoutTimeUnit;

    public static Builder builder() {
        return new Builder();
    }

    public void assertSearch(Runnable runnable) {
        this.assertSearch(() -> {
            runnable.run();
            return null;
        });
    }

    public <T> T assertSearch(Supplier<T> function) {
        if (this._getAttempts() == 1) {
            return function.get();
        }
        return this.retrySearch(function);
    }

    protected <T> T retrySearch(Supplier<T> supplier) {
        try {
            return (T)IdempotentRetryAssert.retryAssert((long)this._getTimeout(), this._getTimeoutTimeUnit(), supplier::get);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private SearchRetryFixture() {
    }

    private SearchRetryFixture(SearchRetryFixture searchRetryFixture) {
        this._attempts = searchRetryFixture._attempts;
        this._timeout = searchRetryFixture._timeout;
        this._timeoutTimeUnit = searchRetryFixture._timeoutTimeUnit;
    }

    private int _getAttempts() {
        return GetterUtil.getInteger((Object)this._attempts);
    }

    private int _getTimeout() {
        return GetterUtil.getInteger((Object)this._timeout, (int)3);
    }

    private TimeUnit _getTimeoutTimeUnit() {
        return (TimeUnit)((Object)GetterUtil.getObject((Object)((Object)this._timeoutTimeUnit), (Object)((Object)TimeUnit.SECONDS)));
    }

    public static class Builder {
        private final SearchRetryFixture _searchRetryFixture = new SearchRetryFixture();

        public Builder attempts(Integer attempts) {
            this._searchRetryFixture._attempts = attempts;
            return this;
        }

        public SearchRetryFixture build() {
            return new SearchRetryFixture(this._searchRetryFixture);
        }

        public Builder timeout(Integer timeout, TimeUnit timeoutTimeUnit) {
            this._searchRetryFixture._timeout = timeout;
            this._searchRetryFixture._timeoutTimeUnit = timeoutTimeUnit;
            return this;
        }
    }
}

