/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.Range;
import com.liferay.portal.search.aggregation.bucket.RangeAggregation;
import com.liferay.portal.search.aggregation.bucket.RangeAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseRangeAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testKeyedRanges() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        RangeAggregation rangeAggregation = this.getAggregation();
        rangeAggregation.addRange(new Range(Double.valueOf(11.0), null));
        rangeAggregation.addRange(new Range(Double.valueOf(0.0), Double.valueOf(11.0)));
        rangeAggregation.setKeyed(Boolean.valueOf(true));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)rangeAggregation));
            indexingTestHelper.search();
            RangeAggregationResult rangeAggregationResult = (RangeAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)rangeAggregation);
            ArrayList buckets = new ArrayList(rangeAggregationResult.getBuckets());
            Assert.assertEquals((String)"Num buckets", (long)2L, (long)buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "0.0-11.0", 10L);
            this.assertBucket((Bucket)buckets.get(1), "11.0-*", 10L);
        });
    }

    @Test
    public void testRanges() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        RangeAggregation rangeAggregation = this.getAggregation();
        rangeAggregation.addRange(new Range("< 6", null, Double.valueOf(6.0)));
        rangeAggregation.addRange(new Range(">=6, <=10", Double.valueOf(6.0), Double.valueOf(11.0)));
        rangeAggregation.addRange(new Range("> 10", Double.valueOf(11.0), null));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)rangeAggregation));
            indexingTestHelper.search();
            RangeAggregationResult rangeAggregationResult = (RangeAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)rangeAggregation);
            ArrayList buckets = new ArrayList(rangeAggregationResult.getBuckets());
            Assert.assertEquals((String)((Object)buckets).toString(), (long)3L, (long)buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "< 6", 5L);
            this.assertBucket((Bucket)buckets.get(1), ">=6, <=10", 5L);
            this.assertBucket((Bucket)buckets.get(2), "> 10", 10L);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount) {
        Assert.assertEquals((Object)expectedKey, (Object)bucket.getKey());
        Assert.assertEquals((long)expectedCount, (long)bucket.getDocCount());
    }

    protected RangeAggregation getAggregation() {
        return this.aggregations.range("range", "priority");
    }
}

